<?php

namespace App\Mail;

use App\Models\NewsletterCampaign;
use App\Models\Subscriber;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewsletterCampaignMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(public NewsletterCampaign $campaign, public Subscriber $subscriber)
    {
    }

    public function build(): self
    {
        return $this
            ->subject($this->campaign->subject)
            ->view('emails.newsletter.campaign')
            ->with([
                'campaign' => $this->campaign,
                'subscriber' => $this->subscriber,
                'content' => $this->campaign->content,
                'unsubscribeUrl' => route('newsletter.unsubscribe', $this->subscriber->token),
            ]);
    }
}
