<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class OrderDigitalFulfillmentMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @param array<int, array{title:string,url:string,expires_at:\Carbon\CarbonInterface|null}> $downloads
     */
    public function __construct(public Order $order, public array $downloads)
    {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: __('Your :app digital downloads', ['app' => config('app.name', 'Store')]),
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'emails.orders.digital',
            with: [
                'order' => $this->order,
                'downloads' => $this->downloads,
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
