<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NewsletterCampaign extends Model
{
    protected $guarded = [];

    protected $casts = [
        'scheduled_at' => 'datetime',
        'sent_at' => 'datetime',
    ];

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function scopeScheduled(Builder $query): Builder
    {
        return $query->where('status', 'scheduled');
    }

    public function scopeDue(Builder $query): Builder
    {
        return $query->scheduled()
            ->whereNull('sent_at')
            ->whereNotNull('scheduled_at')
            ->where('scheduled_at', '<=', now());
    }

    public function markSending(): void
    {
        $this->status = 'sending';
        $this->save();
    }

    public function markSent(int $sentCount): void
    {
        $this->status = 'sent';
        $this->sent_at = now();
        $this->sent_count = $sentCount;
        $this->save();
    }

    public function markCancelled(): void
    {
        $this->status = 'cancelled';
        $this->scheduled_at = null;
        $this->save();
    }
}
