<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id','email','name','status','amount_kobo','shipping_kobo','currency','placed_at','address_json','provider','reference','metadata'
    ];

    protected $casts = [
        'placed_at' => 'datetime',
        'address_json' => 'array',
        'metadata' => 'array',
        'shipping_kobo' => 'integer',
    ];

    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }
}
