<?php

namespace App\Providers;

use App\Support\SiteSettings;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(SiteSettings::class, function () {
            return new SiteSettings();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        if (!$this->app->runningInConsole()) {
            $request = $this->app['request'] ?? null;

            if ($request) {
                $scriptName = str_replace('\\', '/', $request->server('SCRIPT_NAME', ''));
                $scriptDir = $scriptName ? rtrim(str_replace('/index.php', '', $scriptName), '/') : '';
                if ($scriptDir !== '' && str_ends_with($scriptDir, '/public')) {
                    $scriptDir = substr($scriptDir, 0, -7); // trim trailing '/public'
                }
                $schemeAndHost = $request->getSchemeAndHttpHost();
                $computedRoot = rtrim($schemeAndHost.($scriptDir && $scriptDir !== '/' ? $scriptDir : ''), '/');

                if ($computedRoot !== '') {
                    URL::forceRootUrl($computedRoot);
                    URL::forceScheme($request->getScheme());
                    config([
                        'app.url' => $computedRoot,
                        'app.asset_url' => $computedRoot,
                    ]);
                    return;
                }
            }
        }

        if (config('app.url')) {
            URL::forceRootUrl(config('app.url'));

            $scheme = parse_url(config('app.url'), PHP_URL_SCHEME);
            if ($scheme) {
                URL::forceScheme($scheme);
            }
        }
    }
}
