<?php

namespace App\Providers;

use App\Services\CartService;
use App\Support\SiteSettings;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class ViewServiceProvider extends ServiceProvider
{
    public function boot(CartService $cart, SiteSettings $siteSettings)
    {
        View::composer('*', function ($view) use ($cart, $siteSettings) {
            $view->with('cartSummary', [
                'qty' => $cart->quantity(),
                'totalKobo' => $cart->totalKobo(),
            ]);
            $view->with('siteSettings', $siteSettings);
        });
    }
}
