<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Support\CountryRepository;

class SelectCountry extends Component
{
    public function __construct(
        public ?string $name = 'country',
        public ?string $id = null,
        public ?string $placeholder = 'Select country',
        public ?string $value = null,
        public bool $required = false,
    ) {
    }

    public function render(): View|Closure|string
    {
        return view('components.select-country', [
            'countries' => CountryRepository::countries(),
        ]);
    }
}
