<?php

namespace App\View\Components;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Collection;
use Illuminate\View\Component;
use App\Support\CountryRepository;

class SelectState extends Component
{
    protected static array $cache = [];

    public function __construct(
        public ?string $name = 'state',
        public ?string $id = null,
        public ?string $placeholder = 'Select state / region',
        public ?string $value = null,
        public bool $required = false,
        public string $country = 'US',
        public ?string $fallback = null,
    ) {
        $this->country = strtoupper($this->country);
        $this->fallback = $this->fallback ?? 'Not required for this country';
    }

    public function render(): View|Closure|string
    {
        return view('components.select-state', [
            'states' => $this->options(),
        ]);
    }

    protected function options(): Collection
    {
        if (! isset(static::$cache[$this->country])) {
            static::$cache[$this->country] = CountryRepository::subdivisions($this->country);
        }

        return static::$cache[$this->country];
    }
}
