<?php

return [
    'appearance' => [
        'primary_color' => '#1A4D8F',
        'primary_alt_color' => '#153F74',
        'accent_color' => '#F5B82E',
        'background_color' => '#FFFFFF',
        'surface_color' => '#F4F4F4',
        'text_color' => '#222222',
        'muted_text_color' => '#64748B',
        'line_color' => '#E2E8F0',
    ],
    'typography' => [
        'heading_font' => 'Merriweather',
        'body_font' => 'Poppins',
        'font_embed_url' => 'https://fonts.googleapis.com/css2?family=Merriweather:wght@400;700;900&family=Poppins:wght@400;600;800&display=swap',
    ],
    'brand' => [
        'logo_path' => null,
        'favicon_path' => null,
    ],
    'content' => [
        'header_tagline' => 'Curated titles & tailored recommendations.',
        'footer_tagline' => 'Bringing together heartfelt stories, practical author tools, and community events for curious readers.',
        'footer_newsletter_hint' => 'No spam. Unsubscribe anytime.',
        'footer_newsletter_title' => 'Newsletter',
        'footer_quick_links_title' => 'Quick Links',
        'home' => [
            'hero_kicker' => 'Playful & Original',
            'hero_title' => 'Stories that spark calm courage.',
            'hero_lead' => 'Discover uplifting fiction and practical guides crafted for readers who want clarity without losing wonder.',
            'hero_primary_label' => 'Browse Books',
            'hero_secondary_label' => 'Read the Blog',
            'featured_heading' => 'Featured Books',
            'featured_subheading' => 'Handpicked titles that readers keep recommending.',
            'about_title' => 'About the author',
            'about_body' => 'We champion stories and resources that make readers feel braver, calmer, and more connected. Expect warm storytelling, practical tools, and a sprinkle of playful wonder.',
            'about_cta_label' => 'Learn more',
            'view_all_label' => 'Explore the full shelf',
            'promo_badge' => 'Upcoming',
            'promo_title' => 'Sky Lantern Notes',
            'promo_body' => 'Short reflections for calm, focus, and courage. Join the launch list to enjoy first-look chapters and preorder bonuses.',
            'promo_cta_label' => 'Get updates',
            'testimonials_title' => 'What readers say',
            'testimonial_1_quote' => 'Clear, kind, and quietly brave.',
            'testimonial_1_name' => 'Ada, Lagos',
            'testimonial_2_quote' => 'Craft you can feel on every page.',
            'testimonial_2_name' => 'Kemi, Abuja',
            'testimonial_3_quote' => 'Left me lighter and focused.',
            'testimonial_3_name' => 'Nifemi, Ibadan',
            'blog_title' => 'Fresh from the blog',
            'blog_subheading' => 'Practical tips and behind-the-pages reflections.',
            'blog_cta_label' => 'View all posts',
            'newsletter_title' => "Let's stay in touch",
            'newsletter_body' => 'Get launch invites, giveaways, and reading prompts straight to your inbox.',
            'newsletter_cta_label' => 'Subscribe',
            'contact_title' => 'Share a quick note',
            'contact_body' => "Have an event idea or want to collaborate? Leave a message and we'll get back to you.",
        ],
        'about' => [
            'page_title' => 'About the author',
            'intro_body' => 'BrightQuill exists for readers who crave gentle courage and clear-eyed hope. Every project blends storytelling, research, and a practical toolkit so you finish with both warmth and next steps.',
            'intro_secondary' => 'Beyond the page, we mentor emerging authors, partner with bookstores, and share resources that make creative work sustainable. Our goal is to build a welcoming corner for curious readers and indie storytellers.',
            'invite_cta_label' => 'Invite us to speak',
            'themes_title' => 'Core themes',
            'themes' => [
                'Attention as a creative superpower',
                'Calm courage over loud confidence',
                'Craft as care for every reader',
            ],
            'metrics_title' => 'By the numbers',
            'metric_years_value' => '10+',
            'metric_years_label' => 'years curating stories',
            'metric_posts_value' => '12',
            'metric_posts_label' => 'published articles',
            'metric_catalog_value' => '24',
            'metric_catalog_label' => 'books & goods in our catalog',
            'approach_title' => 'Creative approach',
            'approach_body' => 'Each release begins with reader interviews and a meal of margin notes. We map the feelings a story should leave behind, then chase language and structure that support those emotions. Editing is where clarity lives, so we revisit pages until every sentence earns its spot.',
            'collaborate_title' => 'How we collaborate',
            'collaborate_body' => 'Workshops, library takeovers, podcast chats, and curated reading guides are our favorite ways to connect. If your community needs a fresh perspective on resilience, creativity, or compassionate storytelling, let\'s plan something special.',
            'collaborate_cta_label' => 'View services & tools',
        ],
        'services' => [
            'page_title' => 'Services & tools',
            'intro_body' => 'Build a reader-loved brand with offerings crafted for indie authors, bookshops, and creative teams. Each engagement balances storytelling craft with practical, repeatable systems.',
            'strategy_badge' => 'Strategy',
            'strategy_title' => 'Story roadmap',
            'strategy_body' => 'Plot diagnostics, tone planning, and scene sequencing for manuscripts in development.',
            'strategy_cta_label' => 'Book a session',
            'design_badge' => 'Design',
            'design_title' => 'Author site starter',
            'design_body' => 'A bright, responsive site theme with pages for books, newsletter, and blog.',
            'design_cta_label' => 'Request details',
            'launch_badge' => 'Launch',
            'launch_title' => 'Promotions toolkit',
            'launch_body' => 'Email templates, giveaway flows, and checklists to keep launch weeks calm.',
            'launch_cta_label' => 'See promotions',
            'expect_title' => 'What to expect',
            'expect_points' => [
                'Friendly intake questionnaires that surface your goals fast.',
                'Clear action plans with timelines, assets, and owners.',
                'Check-ins that celebrate progress and unblock roadblocks.',
            ],
            'tools_title' => 'Tool stack we love',
            'tools_points' => [
                'Notion dashboards for editorial calendars.',
                'Canva brand kits with launch-ready templates.',
                'Mailerlite automations for reader journeys.',
                'Airtable for tour requests and partner tracking.',
            ],
            'partner_title' => 'Partner with us',
            'partner_body' => 'From library residencies to co-branded workshops, we design experiences that feel personal and doable. Share your idea and we\'ll assemble a plan that aligns with your timeline.',
            'partner_cta_label' => 'Start the conversation',
            'downloads_title' => 'Downloadable resources',
            'download_1_title' => 'Launch checklist',
            'download_1_body' => 'A four-week countdown for stress-free release days.',
            'download_2_title' => 'Newsletter prompts',
            'download_2_body' => '12 thoughtful email ideas to keep readers engaged.',
        ],
        'contact' => [
            'page_title' => 'Say hello',
            'intro_body' => 'Have a question about an order, want to collaborate on an event, or need a custom reading guide? Drop a note and we will reply within two business days.',
            'details_title' => 'Quick details',
            'details_email_label' => 'Email',
            'details_hours' => 'Office hours: Mon - Fri, 9am to 4pm WAT',
            'details_press' => 'Press kit available upon request.',
            'form_title' => 'Send a message',
            'form_name_label' => 'Name',
            'form_email_label' => 'Email',
            'form_message_label' => 'Message',
            'form_submit_label' => 'Send message',
        ],
        'books' => [
            'index_title' => 'Browse the shelves',
            'index_intro' => 'Use the filters to find the perfect read, from cozy essays to high-stakes fiction and limited-edition merch.',
            'add_button_label' => 'Add',
            'view_button_label' => 'View',
        ],
        'book' => [
            'badge_label' => 'book',
            'excerpt_fallback' => 'A reader-loved release from BrightQuill.',
            'related_title' => 'You may also enjoy',
        ],
        'blog' => [
            'index_title' => 'BrightQuill Journal',
            'index_intro' => 'Short essays and production notes for readers who enjoy process, margin scribbles, and joyful marketing experiments.',
            'read_story_label' => 'Read story',
            'comment_name_label' => 'Name',
            'comment_body_label' => 'Comment',
            'comments_title' => 'Join the discussion',
            'comments_submit_label' => 'Post comment',
            'recent_comments_title' => 'Recent comments',
        ],
        'promotions' => [
            'index_title' => 'Current promotions',
            'index_intro' => 'Limited-time treats for readers and creative partners. Enter below and share with your book club.',
            'view_details_label' => 'View details',
            'enter_title' => 'Enter giveaway',
            'enter_submit_label' => 'Submit entry',
        ],
        'merch' => [
            'page_title' => 'BrightQuill merch',
            'intro_body' => 'Wearable reminders and desk-friendly tools for the readers who never stop recommending books.',
            'item_title_prefix' => 'Ink & Lantern Tee #',
            'item_description' => 'Soft cotton, hand-drawn illustration, limited run.',
            'enquire_label' => 'Enquire',
        ],
        'cart' => [
            'title' => 'Your cart',
            'empty_message' => 'Your cart is empty.',
            'total_label' => 'Total',
            'guest_prompt' => 'Please login or create an account to continue.',
            'checkout_label' => 'Proceed to checkout',
            'update_label' => 'Update',
            'remove_label' => 'Remove',
            'empty_cta' => 'Explore the catalog',
            'login_label' => 'login',
            'register_label' => 'create an account',
        ],        'checkout' => [
            'contact_title' => 'Contact & delivery',
            'contact_intro' => 'Tell us where to send digital receipts and goodies.',
            'total_label' => 'Total',
            'stripe_label' => 'Pay with Stripe',
            'paypal_label' => 'Pay with PayPal',
            'order_summary_title' => 'Order summary',
            'continue_label' => 'Continue to payment',
        ],
        'checkout_success' => [
            'badge_label' => 'Thank you',
            'title' => 'Order complete',
            'body' => 'Your order :reference is confirmed. A receipt is on its way to your inbox.',
            'cta_label' => 'Continue browsing',
        ],
        'newsletter' => [
            'confirmed_badge' => "You're in",
            'confirmed_title' => 'Subscription confirmed',
            'confirmed_body' => 'Thanks, :email. Expect essays, launch updates, and surprise giveaways in your inbox soon.',
            'confirmed_cta_label' => 'Return home',
            'unsub_badge' => 'Update saved',
            'unsub_title' => "You're unsubscribed",
            'unsub_body' => ':email, we will stop sending newsletter emails. You are always welcome back whenever you miss us.',
            'unsub_cta_label' => 'Return home',
        ],
    ],
];









