<?php\n\nnamespace Database\Factories;\n\nuse App\Models\Product;\nuse Illuminate\Database\Eloquent\Factories\Factory;\nuse Illuminate\Support\Str;\n\n/**\n * @extends Factory<Product>\n */\nclass ProductFactory extends Factory\n{\n    protected  = Product::class;\n\n    public function definition(): array\n    {\n         = ->faker->unique()->sentence(3);\n         = ->faker->numberBetween(1500, 15000) * 100; // Price in cents\n         = ->faker->boolean(30) ? (int) round( * ->faker->randomFloat(2, 0.6, 0.95)) : null;\n         = ->faker->randomElement(['ebook','audiobook','magazine','journal','comic']);\n         = ->faker->boolean(40);\n\n        return [\n            'title' => ,\n            'slug' => Str::slug() . '-' . Str::random(4),\n            'type' => ,\n            'excerpt' => ->faker->paragraph(),\n            'description' => ->faker->paragraphs(3, true),\n            'price_kobo' => ,\n            'sale_price_kobo' => ,\n            'shipping_fee_kobo' =>  ? ->faker->numberBetween(300, 1500) : 0,\n            'stock' => ->faker->numberBetween(0, 200),\n            'cover_path' => null,\n            'download_path' => null,\n            'download_disk' => null,\n            'has_hardcopy' => ,\n            'hardcopy_price_kobo' =>  ? (int) round( * ->faker->randomFloat(2, 1.05, 1.5)) : null,\n            'is_featured' => ->faker->boolean(25),\n            'published_at' => ->faker->dateTimeBetween('-6 months', 'now'),\n        ];\n    }\n}\n
