<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->boolean('has_hardcopy')->default(false)->after('download_disk');
            $table->unsignedBigInteger('hardcopy_price_kobo')->nullable()->after('has_hardcopy');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['has_hardcopy', 'hardcopy_price_kobo']);
        });
    }
};
