
(function(){
  const root = document.documentElement;
  root.classList.add('js-ready');
  const openBtn = document.querySelector('.menu-btn');
  const drawer = document.querySelector('.drawer');
  if(openBtn && drawer){
    openBtn.addEventListener('click', ()=> root.classList.toggle('mobile-open'));
    drawer.addEventListener('click', (e)=>{ if(e.target === drawer) root.classList.remove('mobile-open'); });
  }
  window.toast = function(msg){
    const t = document.querySelector('.toast');
    if(!t) return;
    t.textContent = msg; t.classList.add('show');
    setTimeout(()=> t.classList.remove('show'), 2400);
  }
  if ('IntersectionObserver' in window){
    const io = new IntersectionObserver((entries)=>{
      entries.forEach(e=>{ if(e.isIntersecting){ e.target.classList.add('show'); io.unobserve(e.target);} });
    }, {root:null, rootMargin:"0px 0px -10% 0px", threshold:0.08});
    document.querySelectorAll('.reveal').forEach(el=> io.observe(el));
  } else { document.querySelectorAll('.reveal').forEach(el=> el.classList.add('show')); }
  const splash = document.getElementById('splash');
  if(splash){ setTimeout(()=> splash.classList.add('hide'), 1600); }
})();
