<?php

use Illuminate\Foundation\Application;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Normalize server variables when the app runs from a subdirectory (e.g. /book_store)
$scriptName = str_replace('\\', '/', $_SERVER['SCRIPT_NAME'] ?? '');
$base = '';
if ($scriptName && str_contains($scriptName, '/public/index.php')) {
    $dir = rtrim(dirname($scriptName), '/');
    if ($dir !== '' && $dir !== '.') {
        $base = str_ends_with($dir, '/public')
            ? rtrim(substr($dir, 0, -7), '/')
            : $dir;
    }

    if ($base !== '') {
        // Trim the subdirectory prefix from request-specific values so routes match.
        $stripPrefix = static function (string $value) use ($base): string {
            if (strpos($value, $base . '/') === 0) {
                $value = substr($value, strlen($base));
            } elseif ($value === $base) {
                $value = '/';
            }

            return $value === '' ? '/' : $value;
        };

        if (isset($_SERVER['REQUEST_URI'])) {
            $_SERVER['REQUEST_URI'] = $stripPrefix($_SERVER['REQUEST_URI']);
        }

        foreach (['PATH_INFO', 'ORIG_PATH_INFO'] as $key) {
            if (isset($_SERVER[$key])) {
                $_SERVER[$key] = $stripPrefix($_SERVER[$key]);
            }
        }

        $_SERVER['SCRIPT_NAME'] = $dir.'/index.php';
        $_SERVER['PHP_SELF'] = $_SERVER['SCRIPT_NAME'];
    }
}

// Determine if the application is in maintenance mode...
if (file_exists($maintenance = __DIR__ . '/../storage/framework/maintenance.php')) {
    require $maintenance;
}

// Register the Composer autoloader...
require __DIR__ . '/../vendor/autoload.php';

// Bootstrap Laravel and handle the request...
/** @var Application $app */
$app = require_once __DIR__ . '/../bootstrap/app.php';

$app->handleRequest(Request::capture());
