@extends('layouts.admin')

@section('content')
<div class="max-w-3xl mx-auto px-4 py-8" data-aos="fade-up">
    <h1 class="heading text-2xl mb-4">Edit Category</h1>
    <form action="{{ route('admin.categories.update', $category) }}" method="post" class="space-y-3 bg-white border border-slate-200 rounded p-4">
        @csrf @method('PUT')
        <input name="name" id="catName" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Name" value="{{ $category->name }}" required>
        <div>
            <input name="slug" id="catSlug" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Slug (optional)" value="{{ $category->slug }}">
            <div class="text-xs text-slate-500 mt-1" id="slugHint"></div>
        </div>
        <button class="btn">Save</button>
    </form>
    <script>
    document.getElementById('catName').addEventListener('input', function(){
        const name = this.value; if(!name){ return; }
        fetch(`{{ route('admin.categories.slug') }}?name=${encodeURIComponent(name)}`)
            .then(r=>r.json()).then(d=>{
                const slugInput = document.getElementById('catSlug');
                if(!slugInput.value){ slugInput.value = d.slug; }
                document.getElementById('slugHint').textContent = d.unique ? 'Slug available' : 'Slug in use, suggested updated';
            }).catch(()=>{});
    });
    </script>
</div>
@endsection
