@extends('layouts.admin')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-8" data-aos="fade-up">
    <h1 class="heading text-2xl mb-4">Comments</h1>
    <div class="overflow-x-auto bg-white border border-slate-200 rounded">
        <table class="w-full text-sm table-sticky table-hover">
            <thead class="bg-slate-50 border-b border-slate-200"><tr><th class="p-2 text-left">Post</th><th class="p-2">Name</th><th class="p-2">Email</th><th class="p-2">Status</th><th class="p-2">Actions</th></tr></thead>
            <tbody>
                @foreach($comments as $c)
                <tr class="border-b border-slate-100">
                    <td class="p-2">{{ optional($c->post)->title }}</td>
                    <td class="p-2 text-center">{{ $c->name }}</td>
                    <td class="p-2 text-center">{{ $c->email }}</td>
                    <td class="p-2 text-center">{{ $c->status }}</td>
                    <td class="p-2 text-right">
                        @can('update',$c)
                        <form action="{{ route('admin.comments.status',$c) }}" method="post" class="inline">@csrf @method('PATCH')
                            <input type="hidden" name="status" value="approved">
                            <button class="text-primary">Approve</button>
                        </form>
                        <form action="{{ route('admin.comments.status',$c) }}" method="post" class="inline ml-2">@csrf @method('PATCH')
                            <input type="hidden" name="status" value="rejected">
                            <button class="text-yellow-600">Reject</button>
                        </form>
                        @endcan
                        @can('delete',$c)
                        <form action="{{ route('admin.comments.destroy',$c) }}" method="post" class="inline ml-2" onsubmit="return confirm('Delete comment?')">@csrf @method('DELETE')
                            <button class="text-red-600">Delete</button>
                        </form>
                        @endcan
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="mt-4">{{ $comments->links() }}</div>
@endsection
