﻿@extends('layouts.admin')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-8" data-aos="fade-up">
    <div class="flex items-center justify-between mb-4">
        <div>
            <h1 class="heading text-3xl">Dashboard</h1>
            <div class="text-sm text-slate-600">Welcome, {{ auth()->user()->name }}</div>
        </div>
        <div class="flex flex-wrap gap-2">
            @can('create', \App\Models\Product::class)
            <a href="{{ route('admin.products.create') }}" class="btn">+ New Product</a>
            @endcan
            <a href="{{ route('admin.orders.index') }}" class="btn-secondary">View Orders</a>
            <a href="{{ route('admin.comments.index') }}" class="btn-secondary">Moderate Comments</a>
            @if(auth()->user()->role === 'admin')
            <a href="{{ route('admin.settings.edit') }}" class="btn-secondary">Settings</a>
            @endif
        </div>
    </div>

    <div class="grid md:grid-cols-6 gap-4 mb-6">
        <a href="{{ route('admin.products.index') }}" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in">
            <div class="text-slate-500 text-sm">Products</div>
            <div class="text-3xl font-bold text-primary">{{ $stats['products'] }}</div>
            <div class="mt-1 text-xs text-slate-500">Low stock: {{ $stats['low_stock'] }}</div>
        </a>
        <a href="{{ route('admin.products.index', ['low'=>1]) }}" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in" data-aos-delay="25">
            <div class="text-slate-500 text-sm">Low Stock</div>
            <div class="text-3xl font-bold text-primary">{{ $stats['low_stock'] }}</div>
            <div class="mt-1 text-xs text-slate-500">Stock &le; 5</div>
        </a>
        <a href="{{ route('admin.orders.index') }}" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in" data-aos-delay="50">
            <div class="text-slate-500 text-sm">Orders</div>
            <div class="text-3xl font-bold text-primary">{{ $stats['orders'] }}</div>
            <div class="mt-1 text-xs text-slate-500">Pending: {{ $stats['pending_orders'] }}</div>
        </a>
        <a href="{{ route('admin.posts.index') }}" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in" data-aos-delay="100">
            <div class="text-slate-500 text-sm">Posts</div>
            <div class="text-3xl font-bold text-primary">{{ $stats['posts'] }}</div>
        </a>
        <a href="{{ route('admin.comments.index') }}" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in" data-aos-delay="150">
            <div class="text-slate-500 text-sm">Comments</div>
            <div class="text-3xl font-bold text-primary">{{ $stats['pending_comments'] }}</div>
            <div class="mt-1 text-xs text-slate-500">Pending</div>
        </a>
        @if(auth()->user()->role === 'admin')
        <a href="{{ route('admin.settings.edit') }}" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in" data-aos-delay="200">
            <div class="text-slate-500 text-sm">Settings</div>
            <div class="text-3xl font-bold text-primary">&#9881;</div>
            <div class="mt-1 text-xs text-slate-500">Payments &amp; more</div>
        </a>
        @endif
    </div>

    <div class="grid lg:grid-cols-2 gap-6">
        <div class="bg-white border border-slate-200 rounded p-4 shadow-sm">
            <div class="flex items-center justify-between mb-3">
                <div class="font-semibold">Latest Orders</div>
                <a href="{{ route('admin.orders.index') }}" class="text-primary text-sm">View all</a>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm table-sticky table-hover">
                    <thead class="bg-slate-50 border-b border-slate-200">
                        <tr><th class="p-2 text-left">Ref</th><th class="p-2">Email</th><th class="p-2">Amount</th><th class="p-2">Status</th><th class="p-2">Type</th></tr>
                    </thead>
                    <tbody>
                        @forelse($latestOrders as $order)
                        <tr class="border-b border-slate-100">
                            <td class="p-2"><a class="text-primary" href="{{ route('admin.orders.show', $order) }}">{{ $order->reference }}</a></td>
                            <td class="p-2 text-center">{{ $order->email }}</td>
                            <td class="p-2 text-center">{{ config('payment.currency_symbol', '$') }}{{ number_format($order->amount_kobo/100,2) }}</td>
                            <td class="p-2 text-center">{{ ucfirst($order->status) }}</td>
                            <td class="p-2 text-center">@if(data_get($order->metadata,'is_test'))<span class="inline-block text-xs bg-yellow-100 text-yellow-800 px-2 py-0.5 rounded">Test</span>@else Real @endif</td>
                        </tr>
                        @empty
                        <tr><td class="p-3 text-slate-500" colspan="5">No orders yet.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <div class="bg-white border border-slate-200 rounded p-4 shadow-sm">
            <div class="flex items-center justify-between mb-3">
                <div class="font-semibold">Recent Posts</div>
                <div class="flex gap-2">
                    @can('create', \App\Models\Product::class)
                    <a href="{{ route('admin.products.create') }}" class="btn px-3 py-1">New Product</a>
                    @endcan
                    @can('create', \App\Models\Post::class)
                    <a href="{{ route('admin.posts.create') }}" class="btn px-3 py-1">New Post</a>
                    @endcan
                </div>
            </div>
            <ul class="text-sm space-y-2">
                @forelse($recentPosts as $post)
                <li class="flex justify-between">
                    <a class="text-primary" href="{{ route('admin.posts.edit', $post) }}">{{ $post->title }}</a>
                    <span class="text-slate-500">{{ optional($post->published_at)->format('Y-m-d') ?: 'Draft' }}</span>
                </li>
                @empty
                <li class="text-slate-500">No posts yet.</li>
                @endforelse
            </ul>
        </div>
    </div>
</div>
@endsection
