@extends('layouts.admin')

@section('content')
<div class="max-w-3xl mx-auto px-4 py-8" data-aos="fade-up">
    <div class="flex items-center justify-between mb-6">
        <div>
            <h1 class="heading text-3xl">Create Newsletter</h1>
            <p class="text-sm text-slate-500">Compose your message and choose whether to send immediately or schedule.</p>
        </div>
        <a href="{{ route('admin.newsletters.index') }}" class="btn-secondary">Back</a>
    </div>

    <div class="bg-white border border-slate-200 rounded shadow-sm p-6">
        <div class="mb-4 text-sm text-slate-600">
            Active subscribers ready to receive: <span class="font-semibold text-ink">{{ $subscriberCount }}</span>
        </div>
        <form method="post" action="{{ route('admin.newsletters.store') }}" class="space-y-5">
            @csrf
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1">Subject</label>
                <input name="subject" type="text" value="{{ old('subject') }}" required class="w-full border border-slate-300 rounded px-3 py-2">
                @error('subject')
                    <div class="text-rose-600 text-xs mt-1">{{ $message }}</div>
                @enderror
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1">Content</label>
                <textarea name="content" rows="10" required class="w-full border border-slate-300 rounded px-3 py-2">{{ old('content') }}</textarea>
                <p class="text-xs text-slate-500 mt-1">Plain text supported. Line breaks will be preserved in the email.</p>
                @error('content')
                    <div class="text-rose-600 text-xs mt-1">{{ $message }}</div>
                @enderror
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1">Delivery</label>
                <div class="space-y-2 text-sm">
                    <label class="flex items-center gap-2">
                        <input type="radio" name="delivery_type" value="now" {{ old('delivery_type', 'now') === 'now' ? 'checked' : '' }}>
                        <span>Send immediately</span>
                    </label>
                    <label class="flex items-center gap-2">
                        <input type="radio" name="delivery_type" value="schedule" {{ old('delivery_type') === 'schedule' ? 'checked' : '' }}>
                        <span>Schedule for later</span>
                    </label>
                </div>
                @error('delivery_type')
                    <div class="text-rose-600 text-xs mt-1">{{ $message }}</div>
                @enderror
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1">Schedule date</label>
                <input type="datetime-local" name="scheduled_for" value="{{ old('scheduled_for') }}" class="border border-slate-300 rounded px-3 py-2">
                <p class="text-xs text-slate-500 mt-1">Required if you choose to schedule.</p>
                @error('scheduled_for')
                    <div class="text-rose-600 text-xs mt-1">{{ $message }}</div>
                @enderror
            </div>
            <div class="flex items-center gap-3">
                <button class="btn px-6 py-2">Save</button>
                <a href="{{ route('admin.newsletters.index') }}" class="btn-secondary px-6 py-2">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection
