@extends('layouts.admin')

@section('content')
<div class="max-w-3xl mx-auto px-4 py-8" data-aos="fade-up">
    <h1 class="heading text-2xl mb-4">New Product</h1>
    <form action="{{ route('admin.products.store') }}" method="post" enctype="multipart/form-data" class="space-y-3 bg-white border border-slate-200 rounded p-4" x-data>
        @csrf
        <input name="title" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Title" required>
        <div class="grid grid-cols-2 gap-3">
            <select name="type" class="border border-slate-300 rounded px-3 py-2" required>
                @php($types = ['ebook','audiobook','magazine','journal','comic'])
                @foreach($types as $t)
                    <option value="{{ $t }}">{{ ucfirst($t) }}</option>
                @endforeach
            </select>
            <input type="file" name="cover_image" accept="image/*" class="border border-slate-300 rounded px-3 py-2 bg-white">
        </div>
        <div class="grid grid-cols-2 gap-3">
            <select name="category_id" class="border border-slate-300 rounded px-3 py-2">
                <option value="">-- Select category --</option>
                @foreach(\App\Models\Category::orderBy('name')->get() as $cat)
                    <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                @endforeach
            </select>
            <input name="category_name" class="border border-slate-300 rounded px-3 py-2" placeholder="Or create new category">
        </div>
        <div class="grid grid-cols-2 gap-3 items-center">
            <input type="number" step="0.01" name="price_amount" class="border border-slate-300 rounded px-3 py-2" placeholder="Digital price (USD)" required>
            <div class="flex items-center gap-2">
                <label class="inline-flex items-center gap-2"><input type="checkbox" id="on_sale_toggle"> On sale</label>
                <input type="number" step="0.01" name="sale_price_amount" id="sale_price_input" class="border border-slate-300 rounded px-3 py-2 hidden" placeholder="Sale price (USD)">
            </div>
        </div>
        <div class="grid grid-cols-2 gap-3">
            <label class="flex items-center gap-2">
                <input type="checkbox" name="has_hardcopy" value="1" id="hardcopy_toggle">
                <span>Hardcopy available</span>
            </label>
            <input type="number" step="0.01" min="0" name="hardcopy_price_amount" id="hardcopy_price_input" class="border border-slate-300 rounded px-3 py-2 hidden" placeholder="Hardcopy price (USD)" disabled>
        </div>
        <div class="grid grid-cols-2 gap-3 hidden" id="hardcopy_inventory_fields">
            <input type="number" name="stock" id="stock_input" class="border border-slate-300 rounded px-3 py-2" placeholder="Hardcopy stock" min="0" disabled>
            <input type="number" step="0.01" min="0" name="shipping_fee_amount" id="shipping_fee_input" class="border border-slate-300 rounded px-3 py-2" placeholder="Hardcopy shipping fee (USD)" disabled>
        </div>
        <div class="grid grid-cols-1 gap-3">
            <input type="file" name="download_file" class="border border-slate-300 rounded px-3 py-2 bg-white" accept=".pdf,.epub,.mobi,.zip,.mp3,.wav,.mp4,.doc,.docx,.txt,.rtf,.ppt,.pptx,.xls,.xlsx,.aiff,.flac">
        </div>
        <p class="text-xs text-slate-500">Upload a digital file for downloadable formats. If the hardcopy option is enabled, provide pricing (and optional shipping fee) for the physical edition.</p>
        <textarea name="excerpt" rows="3" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Short excerpt"></textarea>
        <textarea name="description" rows="6" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Description"></textarea>
        <div id="dropzone" class="border-2 border-dashed border-slate-300 rounded p-4 text-center text-slate-500">
            Drag and drop cover image here or click the file input above.
            <div class="mt-3">
                <img id="preview" class="mx-auto h-32 hidden rounded border border-slate-200" alt="preview">
            </div>
        </div>
        <script>
        const fileInput = document.querySelector('input[name="cover_image"]');
        const dz = document.getElementById('dropzone');
        const pv = document.getElementById('preview');
        function showPreview(file){
            const reader = new FileReader();
            reader.onload = e => { pv.src = e.target.result; pv.classList.remove('hidden'); };
            reader.readAsDataURL(file);
        }
        fileInput?.addEventListener('change', e => { const f = e.target.files?.[0]; if(f) showPreview(f); });
        dz.addEventListener('dragover', e => { e.preventDefault(); dz.classList.add('bg-slate-50'); });
        dz.addEventListener('dragleave', () => { dz.classList.remove('bg-slate-50'); });
        dz.addEventListener('drop', e => { e.preventDefault(); dz.classList.remove('bg-slate-50'); const f = e.dataTransfer.files?.[0]; if(f){ const dt = new DataTransfer(); dt.items.add(f); fileInput.files = dt.files; showPreview(f); } });
        const saleToggle = document.getElementById('on_sale_toggle');
        const saleInput = document.getElementById('sale_price_input');
        saleToggle?.addEventListener('change', () => {
            if (saleToggle.checked) { saleInput.classList.remove('hidden'); saleInput.required = true; }
            else { saleInput.classList.add('hidden'); saleInput.required = false; saleInput.value=''; }
        });
        const hardcopyToggle = document.getElementById('hardcopy_toggle');
        const hardcopyInput = document.getElementById('hardcopy_price_input');
        const hardcopyFields = document.getElementById('hardcopy_inventory_fields');
        const stockInput = document.getElementById('stock_input');
        const shippingInput = document.getElementById('shipping_fee_input');
        const syncHardcopyFields = () => {
            if (hardcopyToggle?.checked) {
                hardcopyInput?.classList.remove('hidden');
                hardcopyInput?.removeAttribute('disabled');
                hardcopyInput.required = true;
                hardcopyFields?.classList.remove('hidden');
                stockInput?.removeAttribute('disabled');
                stockInput?.setAttribute('required','required');
                shippingInput?.removeAttribute('disabled');
            } else {
                hardcopyInput?.classList.add('hidden');
                hardcopyInput?.setAttribute('disabled','disabled');
                hardcopyInput.required = false;
                hardcopyInput.value = '';
                hardcopyFields?.classList.add('hidden');
                if (stockInput) {
                    stockInput.value = '';
                    stockInput.setAttribute('disabled','disabled');
                    stockInput.removeAttribute('required');
                }
                if (shippingInput) {
                    shippingInput.value = '';
                    shippingInput.setAttribute('disabled','disabled');
                }
            }
        };
        hardcopyToggle?.addEventListener('change', syncHardcopyFields);
        syncHardcopyFields();
        </script>
        <div class="grid grid-cols-2 gap-3">
            <label class="flex items-center gap-2"><input type="checkbox" name="is_featured" value="1"> Featured</label>
            <input type="datetime-local" name="published_at" class="border border-slate-300 rounded px-3 py-2">
        </div>
        <button class="btn">Create</button>
    </form>
</div>
@endsection
