@extends('layouts.admin')

@section('content')
<div class="max-w-3xl mx-auto px-4 py-8" data-aos="fade-up">
    <h1 class="heading text-2xl mb-4">Edit Product</h1>
    <form action="{{ route('admin.products.update', $product) }}" method="post" enctype="multipart/form-data" class="space-y-3 bg-white border border-slate-200 rounded p-4" x-data>
        @csrf
        @method('PUT')
        <input name="title" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Title" value="{{ $product->title }}" required>
        <div class="grid grid-cols-2 gap-3">
            @php($types = ['ebook','audiobook','magazine','journal','comic'])
            <select name="type" class="border border-slate-300 rounded px-3 py-2" required>
                @foreach($types as $t)
                    <option value="{{ $t }}" @selected($product->type === $t)>{{ ucfirst($t) }}</option>
                @endforeach
                @if($product->type && !in_array($product->type, $types))
                    <option value="{{ $product->type }}" selected>{{ ucfirst($product->type) }}</option>
                @endif
            </select>
            <div>
                <input type="file" name="cover_image" accept="image/*" class="border border-slate-300 rounded px-3 py-2 bg-white w-full">
                @if($product->cover_path)
                    <img src="{{ asset($product->cover_path) }}" alt="cover" class="mt-2 h-20 rounded border border-slate-200">
                @endif
            </div>
        </div>
        <div class="grid grid-cols-2 gap-3">
            <select name="category_id" class="border border-slate-300 rounded px-3 py-2">
                <option value="">-- Select category --</option>
                @foreach(\App\Models\Category::orderBy('name')->get() as $cat)
                    <option value="{{ $cat->id }}" @selected($product->category_id==$cat->id)>{{ $cat->name }}</option>
                @endforeach
            </select>
            <input name="category_name" class="border border-slate-300 rounded px-3 py-2" placeholder="Or create new category">
        </div>
        <div class="grid grid-cols-2 gap-3">
            <input type="number" step="0.01" name="price_amount" class="border border-slate-300 rounded px-3 py-2" placeholder="Digital price (USD)" value="{{ number_format($product->price_kobo/100,2,'.','') }}" required>
            <input type="number" step="0.01" name="sale_price_amount" class="border border-slate-300 rounded px-3 py-2" placeholder="Sale price (USD)" value="{{ $product->sale_price_kobo ? number_format($product->sale_price_kobo/100,2,'.','') : '' }}">
        </div>
        <div class="grid grid-cols-2 gap-3">
            <label class="flex items-center gap-2">
                <input type="checkbox" name="has_hardcopy" value="1" id="hardcopy_toggle_edit" @checked($product->has_hardcopy)>
                <span>Hardcopy available</span>
            </label>
            <input type="number" step="0.01" min="0" name="hardcopy_price_amount" id="hardcopy_price_input_edit" class="border border-slate-300 rounded px-3 py-2 {{ $product->has_hardcopy ? '' : 'hidden' }}" placeholder="Hardcopy price (USD)" value="{{ $product->hardcopy_price_kobo ? number_format($product->hardcopy_price_kobo/100,2,'.','') : '' }}" @disabled(!$product->has_hardcopy)>
        </div>
        <div class="grid grid-cols-2 gap-3 {{ $product->has_hardcopy ? '' : 'hidden' }}" id="hardcopy_inventory_fields_edit">
            <input type="number" name="stock" id="stock_input_edit" class="border border-slate-300 rounded px-3 py-2" placeholder="Hardcopy stock" min="0" value="{{ $product->stock }}" @disabled(!$product->has_hardcopy)>
            <input type="number" step="0.01" min="0" name="shipping_fee_amount" id="shipping_fee_input_edit" class="border border-slate-300 rounded px-3 py-2" placeholder="Hardcopy shipping fee (USD)" value="{{ number_format(($product->shipping_fee_kobo ?? 0)/100, 2, '.', '') }}" @disabled(!$product->has_hardcopy)>
        </div>
        <div class="grid grid-cols-1 gap-3">
            <div>
                <input type="file" name="download_file" class="border border-slate-300 rounded px-3 py-2 bg-white w-full" accept=".pdf,.epub,.mobi,.zip,.mp3,.wav,.mp4,.doc,.docx,.txt,.rtf,.ppt,.pptx,.xls,.xlsx,.aiff,.flac">
                @if($product->download_path)
                    <p class="text-xs text-slate-500 mt-1">Current file: {{ basename($product->download_path) }}</p>
                    <label class="inline-flex items-center gap-2 text-xs text-slate-600 mt-1"><input type="checkbox" name="remove_download" value="1"> Remove existing file</label>
                @endif
            </div>
        </div>
        <p class="text-xs text-slate-500">Maintain the digital details above. If the hardcopy option is enabled, be sure to provide the physical price and shipping fee.</p>
        <textarea name="excerpt" rows="3" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Short excerpt">{{ $product->excerpt }}</textarea>
        <textarea name="description" rows="6" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Description">{{ $product->description }}</textarea>
        <div class="grid grid-cols-2 gap-3">
            <label class="flex items-center gap-2"><input type="checkbox" name="is_featured" value="1" @checked($product->is_featured)> Featured</label>
            <input type="datetime-local" name="published_at" class="border border-slate-300 rounded px-3 py-2" value="{{ optional($product->published_at)->format('Y-m-d\TH:i') }}">
        </div>
        <button class="btn">Save</button>
    </form>
</div>
<script>
    const hardcopyToggleEdit = document.getElementById('hardcopy_toggle_edit');
    const hardcopyPriceEdit = document.getElementById('hardcopy_price_input_edit');
    const hardcopyFieldsEdit = document.getElementById('hardcopy_inventory_fields_edit');
    const stockInputEdit = document.getElementById('stock_input_edit');
    const shippingInputEdit = document.getElementById('shipping_fee_input_edit');
    const syncHardcopyEdit = () => {
        if (hardcopyToggleEdit?.checked) {
            hardcopyPriceEdit?.classList.remove('hidden');
            hardcopyPriceEdit?.removeAttribute('disabled');
            hardcopyPriceEdit.required = true;
            hardcopyFieldsEdit?.classList.remove('hidden');
            stockInputEdit?.removeAttribute('disabled');
            stockInputEdit?.setAttribute('required','required');
            shippingInputEdit?.removeAttribute('disabled');
        } else {
            hardcopyPriceEdit?.classList.add('hidden');
            hardcopyPriceEdit?.setAttribute('disabled','disabled');
            hardcopyPriceEdit.required = false;
            hardcopyPriceEdit.value = '';
            hardcopyFieldsEdit?.classList.add('hidden');
            if (stockInputEdit) {
                stockInputEdit.value = '';
                stockInputEdit.setAttribute('disabled','disabled');
                stockInputEdit.removeAttribute('required');
            }
            if (shippingInputEdit) {
                shippingInputEdit.value = '';
                shippingInputEdit.setAttribute('disabled','disabled');
            }
        }
    };
    hardcopyToggleEdit?.addEventListener('change', syncHardcopyEdit);
    syncHardcopyEdit();
</script>
@endsection
