@extends('layouts.admin')

@section('content')
<div class="max-w-3xl mx-auto px-4 py-8" data-aos="fade-up">
    <h1 class="heading text-2xl mb-4">Payment Settings</h1>

    @if(session('status'))
    <div class="mb-4 bg-emerald-50 border border-emerald-200 text-emerald-900 text-sm rounded px-3 py-2">{{ session('status') }}</div>
    @endif
    @if(session('error'))
    <div class="mb-4 bg-red-50 border border-red-200 text-red-900 text-sm rounded px-3 py-2">{{ session('error') }}</div>
    @endif

    <form method="post" action="{{ route('admin.settings.update') }}" class="space-y-4 bg-white border border-slate-200 rounded p-4">
        @csrf
        <div class="text-sm text-slate-600">Values saved here override .env values. Leave blank to use .env.</div>

        <div x-data="{ reveal:false }">
            <div class="font-semibold mb-2">Stripe</div>
            <div class="flex gap-2 mb-2">
                <input :type="reveal ? 'text' : 'password'" name="stripe_secret" value="{{ old('stripe_secret', $values['stripe_secret']) }}" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Secret key (sk_live_...)" />
                <button type="button" class="border border-slate-300 rounded px-2" @click="reveal=!reveal" x-text="reveal ? 'Hide' : 'Show'"></button>
            </div>
            <input name="stripe_public" value="{{ old('stripe_public', $values['stripe_public']) }}" class="w-full border border-slate-300 rounded px-3 py-2 mb-2" placeholder="Publishable key (pk_live_...)" />
            <input name="stripe_base_url" value="{{ old('stripe_base_url', $values['stripe_base_url']) }}" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="https://api.stripe.com" />
        </div>

        <div x-data="{ reveal:false }">
            <div class="font-semibold mb-2">PayPal</div>
            <input name="paypal_client_id" value="{{ old('paypal_client_id', $values['paypal_client_id']) }}" class="w-full border border-slate-300 rounded px-3 py-2 mb-2" placeholder="Client ID" />
            <div class="flex gap-2 mb-2">
                <input :type="reveal ? 'text' : 'password'" name="paypal_secret" value="{{ old('paypal_secret', $values['paypal_secret']) }}" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Secret" />
                <button type="button" class="border border-slate-300 rounded px-2" @click="reveal=!reveal" x-text="reveal ? 'Hide' : 'Show'"></button>
            </div>
            <input name="paypal_base_url" value="{{ old('paypal_base_url', $values['paypal_base_url']) }}" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="https://api-m.paypal.com" />
        </div>

        <div class="pt-2">
            <label class="inline-flex items-center gap-2">
                <input type="checkbox" name="create_test_order" value="1" @checked($values['create_test_order'])>
                <span>Create a pending test order when running test payments</span>
            </label>
        </div>

        <button class="btn">Save</button>
    </form>

    <div class="bg-white border border-slate-200 rounded p-4 mt-6" x-data>
        <div class="font-semibold mb-2">Test Payments ({{ config('payment.currency_symbol', '$') }}10.00)</div>
        <div class="flex gap-3">
            <form method="post" action="{{ route('admin.settings.test','stripe') }}">@csrf <button class="btn" @disabled(empty($values['stripe_secret']))>Stripe Test</button></form>
            <form method="post" action="{{ route('admin.settings.test','paypal') }}">@csrf <button class="btn" @disabled(empty($values['paypal_client_id']) || empty($values['paypal_secret']))>PayPal Test</button></form>
        </div>
    </div>
</div>
@endsection
