@extends('layouts.admin')

@section('content')
<div class="max-w-5xl mx-auto px-4 py-8" data-aos="fade-up">
    <h1 class="heading text-2xl mb-4">Site Appearance & Content</h1>

    @if(session('status'))
        <div class="mb-4 bg-emerald-50 border border-emerald-200 text-emerald-900 text-sm rounded px-3 py-2">{{ session('status') }}</div>
    @endif

    @if ($errors->any())
        <div class="mb-4 bg-red-50 border border-red-200 text-red-900 text-sm rounded px-3 py-2">
            <ul class="list-disc pl-5 space-y-1">
                @foreach ($errors->all() as $message)
                    <li>{{ $message }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="post" action="{{ route('admin.site.update') }}" class="space-y-6" enctype="multipart/form-data">
        @csrf

        <section class="bg-white border border-slate-200 rounded p-4">
            <h2 class="font-semibold text-lg mb-3">Brand assets</h2>
            <p class="text-xs text-slate-500 mb-4">Upload high-resolution files (logo recommended = 200px square, favicon 3232 PNG or ICO). Leave blank to keep the current image.</p>
            @php
                $logoPath = $brand['logo_path'] ?? null;
                $logoUrl = $logoPath ? \Illuminate\Support\Facades\Storage::disk('public')->url($logoPath) : null;
                $faviconPath = $brand['favicon_path'] ?? null;
                $faviconUrl = $faviconPath ? \Illuminate\Support\Facades\Storage::disk('public')->url($faviconPath) : null;
            @endphp
            <div class="grid md:grid-cols-2 gap-4">
                <div class="space-y-2">
                    <label class="text-sm text-slate-600 flex flex-col gap-1">
                        <span>Primary logo</span>
                        <input type="file" name="brand[logo]" accept="image/*" class="border border-slate-300 rounded px-3 py-2">
                    </label>
                    @error('brand.logo')
                        <p class="text-xs text-red-600">{{ $message }}</p>
                    @enderror
                    @if($logoUrl)
                        <div class="flex items-center gap-3">
                            <img src="{{ $logoUrl }}" alt="Current logo" class="h-12 w-auto rounded border border-slate-200">
                            <label class="text-xs text-slate-600 inline-flex items-center gap-2">
                                <input type="checkbox" name="brand[logo_remove]" value="1" @checked(old('brand.logo_remove'))>
                                <span>Remove logo</span>
                            </label>
                        </div>
                    @endif
                </div>
                <div class="space-y-2">
                    <label class="text-sm text-slate-600 flex flex-col gap-1">
                        <span>Favicon</span>
                        <input type="file" name="brand[favicon]" accept="image/png,image/x-icon,.ico" class="border border-slate-300 rounded px-3 py-2">
                    </label>
                    @error('brand.favicon')
                        <p class="text-xs text-red-600">{{ $message }}</p>
                    @enderror
                    @if($faviconUrl)
                        <div class="flex items-center gap-3">
                            <img src="{{ $faviconUrl }}" alt="Current favicon" class="h-10 w-10 rounded border border-slate-200">
                            <label class="text-xs text-slate-600 inline-flex items-center gap-2">
                                <input type="checkbox" name="brand[favicon_remove]" value="1" @checked(old('brand.favicon_remove'))>
                                <span>Remove favicon</span>
                            </label>
                        </div>
                    @endif
                </div>
            </div>
        </section>

        <section class="bg-white border border-slate-200 rounded p-4">
            <h2 class="font-semibold text-lg mb-3">Colors</h2>
            <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-4">
                @foreach ([
                    'primary_color' => 'Primary',
                    'primary_alt_color' => 'Primary (hover)',
                    'accent_color' => 'Accent',
                    'background_color' => 'Background',
                    'surface_color' => 'Surface',
                    'text_color' => 'Text',
                    'muted_text_color' => 'Muted text',
                    'line_color' => 'Borders',
                ] as $key => $label)
                    <label class="text-sm text-slate-600 flex flex-col gap-1">
                        <span>{{ $label }}</span>
                        <input type="color" name="appearance[{{ $key }}]" value="{{ old("appearance.$key", $appearance[$key] ?? '') }}" class="h-10 w-full border border-slate-300 rounded" />
                    </label>
                @endforeach
            </div>
        </section>

        <section class="bg-white border border-slate-200 rounded p-4">
            <h2 class="font-semibold text-lg mb-3">Typography</h2>
            <div class="grid md:grid-cols-2 gap-4">
                <label class="text-sm text-slate-600 flex flex-col gap-1">
                    <span>Heading font family</span>
                    <input type="text" name="typography[heading_font]" value="{{ old('typography.heading_font', $typography['heading_font'] ?? '') }}" class="border border-slate-300 rounded px-3 py-2" placeholder="e.g. Merriweather" />
                </label>
                <label class="text-sm text-slate-600 flex flex-col gap-1">
                    <span>Body font family</span>
                    <input type="text" name="typography[body_font]" value="{{ old('typography.body_font', $typography['body_font'] ?? '') }}" class="border border-slate-300 rounded px-3 py-2" placeholder="e.g. Poppins" />
                </label>
            </div>
            <label class="text-sm text-slate-600 flex flex-col gap-1 mt-4">
                <span>Google Fonts embed URL</span>
                <input type="text" name="typography[font_embed_url]" value="{{ old('typography.font_embed_url', $typography['font_embed_url'] ?? '') }}" class="border border-slate-300 rounded px-3 py-2" placeholder="https://fonts.googleapis.com/..." />
            </label>
        </section>

        <section class="bg-white border border-slate-200 rounded p-4">
            <h2 class="font-semibold text-lg mb-3">Site Copy</h2>
            <p class="text-xs text-slate-500 mb-4">Update text for public-facing pages. Lists accept one item per line.</p>
            @include('admin.settings.partials.content-fields', [
                'defaults' => config('site.content'),
                'values' => $content,
                'namePrefix' => 'content',
                'dotPrefix' => 'content',
            ])
        </section>

        <div class="flex justify-end">
            <button class="btn">Save changes</button>
        </div>
    </form>
</div>
@endsection

        <section class=\"bg-white border border-slate-200 rounded p-4\">
            <h2 class=\"font-semibold text-lg mb-3\">Home Hero Image</h2>
            @php
                 = ['home_hero_path'] ?? null;
                 =  ? \\Illuminate\\Support\\Facades\\Storage::disk('public')->url() : null;
            @endphp
            <div class=\"space-y-2\">
                <label class=\"text-sm text-slate-600 flex flex-col gap-1\">
                    <span>Upload hero image</span>
                    <input type=\"file\" name=\"brand[home_hero]\" accept=\"image/*\" class=\"border border-slate-300 rounded px-3 py-2\">
                </label>
                @error('brand.home_hero')
                    <p class=\"text-xs text-red-600\">{{  }}</p>
                @enderror
                @if()
                    <div class=\"flex items-center gap-3\">
                        <img src=\"{{  }}\" alt=\"Home hero\" class=\"h-16 w-auto rounded border border-slate-200\">
                        <label class=\"text-xs text-slate-600 inline-flex items-center gap-2\">
                            <input type=\"checkbox\" name=\"brand[home_hero_remove]\" value=\"1\" @checked(old('brand.home_hero_remove'))>
                            <span>Remove image</span>
                        </label>
                    </div>
                @endif
                <p class=\"text-xs text-slate-500\">Recommended minimum size: 600800 (JPG/PNG). This image appears on the homepage hero card.</p>
            </div>
        </section>
