@extends('layouts.auth-card')

@section('content')
<div class="mx-auto w-full max-w-md mt-4 sm:mt-0">
  <h1 class="text-2xl font-semibold text-slate-900">Reset Password</h1>
  <p class="mt-2 text-sm text-slate-600">Create a new password for your account.</p>

  @if ($errors->any())
    <div class="mt-4 rounded-md bg-red-50 p-3 text-sm text-red-700">
      <ul class="list-disc pl-5">@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
    </div>
  @endif

  <form class="mt-5 space-y-4" method="POST" action="{{ route('password.store') }}">
    @csrf
    <input type="hidden" name="token" value="{{ $request->route('token') }}">
    <div class="relative">
      <span class="pointer-events-none absolute inset-y-0 left-3 inline-flex items-center text-slate-400">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 7l9 6 9-6M5 6h14a2 2 0 012 2v8a2 2 0 01-2 2H5a2 2 0 01-2-2V8a2 2 0 012-2z"/></svg>
      </span>
      <input id="email" name="email" type="email" required autocomplete="email" value="{{ old('email', $request->email) }}" class="w-full rounded-xl border-0 bg-slate-50 pl-10 pr-3 py-3 text-slate-900 shadow-inner focus:ring-2 focus:ring-cyan-400 focus:outline-none" placeholder="Email address" />
    </div>
    <div class="relative">
      <span class="pointer-events-none absolute inset-y-0 left-3 inline-flex items-center text-slate-400">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 11V7a4 4 0 118 0v4m-9 0h10a2 2 0 012 2v5a2 2 0 01-2 2H7a2 2 0 01-2-2v-5a2 2 0 012-2z"/></svg>
      </span>
      <input id="password" name="password" type="password" required autocomplete="new-password" class="w-full rounded-xl border-0 bg-slate-50 pl-10 pr-3 py-3 text-slate-900 shadow-inner focus:ring-2 focus:ring-cyan-400 focus:outline-none" placeholder="New password" />
    </div>
    <div class="relative">
      <span class="pointer-events-none absolute inset-y-0 left-3 inline-flex items-center text-slate-400">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 11V7a4 4 0 118 0v4m-9 0h10a2 2 0 012 2v5a2 2 0 01-2 2H7a2 2 0 01-2-2v-5a2 2 0 012-2z"/></svg>
      </span>
      <input id="password_confirmation" name="password_confirmation" type="password" required autocomplete="new-password" class="w-full rounded-xl border-0 bg-slate-50 pl-10 pr-3 py-3 text-slate-900 shadow-inner focus:ring-2 focus:ring-cyan-400 focus:outline-none" placeholder="Confirm password" />
    </div>
    <button type="submit" class="w-full rounded-full bg-cyan-600 px-5 py-2.5 text-white shadow-inner hover:bg-cyan-700 focus:outline-none focus:ring-2 focus:ring-cyan-400">Reset Password</button>
  </form>
</div>
@endsection

