@extends('layouts.site')

@php $cartContent = $siteSettings->content('cart'); @endphp
@section('title', $cartContent['title'] ?? 'Your cart')
@section('meta_description', $cartContent['empty_message'] ?? 'Review the books and merchandise currently saved in your cart.')

@php
    $currency = config('payment.currency_symbol', '$');
@endphp

@section('content')
<section class="section reveal">
    <div class="container">
        <h1 class="mt-0">{{ $cartContent['title'] ?? 'Your cart' }}</h1>
        @if(empty($items))
            <p class="small">{{ $cartContent['empty_message'] ?? 'Your cart is empty.' }} <a href="{{ route('books.index') }}">{{ $siteSettings->get('content.cart.empty_cta', 'Explore the catalog') }}</a></p>
        @else
            <div class="grid" style="gap:1rem;">
                @foreach($items as $item)
                    <article class="card reveal" style="display:flex;gap:1rem;align-items:flex-start;">
                        <img src="{{ $item['cover_path'] ?: asset('brightquill/assets/placeholder-cover.svg') }}" alt="{{ $item['title'] }}" style="width:96px;height:128px;object-fit:cover;border-radius:12px;">
                        <div class="card-body" style="padding:0;flex:1;">
                            <h3 class="card-title" style="margin-bottom:.35rem;">{{ $item['title'] }}</h3>
                            <p class="text-xs uppercase tracking-wide text-slate-500" style="margin:0 0 .5rem 0;">{{ $item['variant_label'] ?? (($item['is_digital'] ?? false) ? 'DIGITAL' : 'HARDCOPY') }}</p>
                            <p class="card-sub">
                                {{ $currency }}{{ number_format(($item['price_kobo'] ?? 0)/100, 2) }}
                                @if(($item['shipping_fee_kobo'] ?? 0) > 0)
                                    <span class="text-xs text-slate-500">+ {{ $currency }}{{ number_format(($item['shipping_fee_kobo'] ?? 0)/100, 2) }} shipping</span>
                                @endif
                            </p>
                            @if(!($item['is_digital'] ?? false))
                                <form class="row" action="{{ route('cart.update') }}" method="post" style="gap:.75rem;align-items:center;margin-top:0.5rem;">
                                    @csrf
                                    @method('PATCH')
                                    <input type="hidden" name="product_id" value="{{ $item['product_id'] }}">
                                    <input type="hidden" name="variant" value="{{ $item['variant'] ?? 'digital' }}">
                                    <label class="small" for="qty-{{ $loop->index }}">Qty</label>
                                    <input class="input" id="qty-{{ $loop->index }}" style="max-width:110px;" type="number" min="0" name="qty" value="{{ $item['qty'] }}">
                                    <button class="btn btn-outline" type="submit">{{ $siteSettings->get('content.cart.update_label', 'Update') }}</button>
                                </form>
                            @else
                                <p class="small text-slate-500" style="margin-top:0.5rem;">Digital items are limited to a single copy per order.</p>
                            @endif
                        </div>
                        <form action="{{ route('cart.remove') }}" method="post" style="margin-left:auto;">
                            @csrf
                            @method('DELETE')
                            <input type="hidden" name="product_id" value="{{ $item['product_id'] }}">
                            <input type="hidden" name="variant" value="{{ $item['variant'] ?? 'digital' }}">
                            <button class="btn btn-outline" type="submit">{{ $siteSettings->get('content.cart.remove_label', 'Remove') }}</button>
                        </form>
                    </article>
                @endforeach
            </div>
            <div class="card mt-3 reveal">
                <div class="card-body" style="display:flex;flex-wrap:wrap;gap:1rem;justify-content:space-between;align-items:center;">
                    <div>
                        <div class="text-sm text-slate-500">{{ $cartContent['subtotal_label'] ?? 'Subtotal' }}: {{ $currency }}{{ number_format(($subtotalKobo ?? 0)/100, 2) }}</div>
                        @if(($shippingKobo ?? 0) > 0)
                            <div class="text-sm text-slate-500">{{ $cartContent['shipping_label'] ?? 'Shipping' }}: {{ $currency }}{{ number_format(($shippingKobo ?? 0)/100, 2) }}</div>
                        @endif
                        <div class="h1" style="font-size:1.4rem;margin:0;">{{ $cartContent['total_label'] ?? 'Total' }}: {{ $currency }}{{ number_format(($totalKobo ?? 0)/100, 2) }}</div>
                    </div>
                    <div style="display:flex;flex-direction:column;gap:.5rem;align-items:flex-end;min-width:220px;">
                        <a class="btn btn-primary" href="{{ route('checkout.show') }}">{{ $cartContent['checkout_label'] ?? 'Proceed to checkout' }}</a>
                        @guest
                            <p class="small" style="text-align:right;">{{ $cartContent['guest_prompt'] ?? 'Have an account? Log in to save your order history.' }} <a href="{{ route('login') }}">{{ $cartContent['login_label'] ?? 'Login' }}</a>@if(Route::has('register')) or <a href="{{ route('register') }}">{{ $cartContent['register_label'] ?? 'Create an account' }}</a>@endif.</p>
                        @endguest
                    </div>
                </div>
            </div>
        @endif
    </div>
</section>
@endsection
