@extends('layouts.site')

@section('title', 'Order Confirmed')
@php $successContent = $siteSettings->content('checkout_success'); @endphp
@section('meta_description', $successContent['body'] ?? 'Confirmation details for your recent order.')

@section('content')
<section class="section reveal">
    <div class="container" style="max-width:640px;text-align:center;">
        <div class="badge-pill">{{ $successContent['badge_label'] ?? 'Thank you' }}</div>
        <h1 class="mt-2">{{ $successContent['title'] ?? 'Order complete' }}</h1>
        <p>{{ str_replace(':reference', $order->reference, $successContent['body'] ?? 'Your order :reference is confirmed. A receipt is on its way to your inbox.') }}</p>
        <a class="btn btn-primary mt-3" href="{{ route('books.index') }}">{{ $successContent['cta_label'] ?? 'Continue browsing' }}</a>
    </div>
</section>
@endsection
