@php
    $fieldId = $id ?? (is_string($name ?? null) ? trim(str_replace(['[',']'], ['_',''], $name), '_') : 'country');
    $selectedValue = is_string($value ?? null) ? strtolower(trim($value)) : null;
@endphp

<select
    id="{{ $fieldId }}"
    name="{{ $name }}"
    {{ $required ? 'required' : '' }}
    {{ $attributes->class(['input']) }}
>
    <option value="">{{ $placeholder }}</option>
    @foreach($countries as $country)
        @php
            $code = strtolower((string) ($country['code'] ?? $country));
            $label = (string) ($country['name'] ?? $country);
        @endphp
        <option value="{{ strtoupper($country['code'] ?? $label) }}" @selected($selectedValue === $code)>
            {{ $label }}
        </option>
    @endforeach
</select>
