@extends('layouts.site')

@section('title', 'Home')
@php $homeContent = $siteSettings->content('home'); @endphp
@section('meta_description', $homeContent['hero_lead'] ?? 'Discover uplifting fiction, thoughtful essays, and reader-first promotions.')

@php
    $currency = config('payment.currency_symbol', '$');
@endphp

@section('content')
<section class="container hero reveal">
    <div>
        <div class="kicker">{{ $homeContent['hero_kicker'] ?? 'Playful & Original' }}</div>
        <h1 class="h1">{{ $homeContent['hero_title'] ?? 'Stories that spark calm courage.' }}</h1>
        <p class="lead">{{ $homeContent['hero_lead'] ?? 'Discover uplifting fiction and practical guides crafted for readers who want clarity without losing wonder.' }}</p>
        <div class="cta-row">
            <a class="btn btn-primary" href="{{ route('books.index') }}">{{ $homeContent['hero_primary_label'] ?? 'Browse Books' }}</a>
            <a class="btn btn-outline" href="{{ route('blog.index') }}">{{ $homeContent['hero_secondary_label'] ?? 'Read the Blog' }}</a>
        </div>
    </div>
    <div class="card center reveal">
        <img src="{{ asset('brightquill/assets/placeholder-cover.svg') }}" alt="Illustrative book stack" style="width:min(420px,100%);">
    </div>
</section>

<section class="section stripe reveal">
    <div class="container">
        <h2 class="mt-0">{{ $homeContent['featured_heading'] ?? 'Featured Books' }}</h2>
        <p class="small mt-1">{{ $homeContent['featured_subheading'] ?? 'Handpicked titles that readers keep recommending.' }}</p>
        <div class="grid grid-3 mt-2">
            @forelse($featured->take(6) as $book)
                <article class="card reveal">
                    <img src="{{ $book->cover_path ? asset($book->cover_path) : asset('brightquill/assets/placeholder-cover.svg') }}" alt="Cover for {{ $book->title }}" style="height:220px;object-fit:cover;width:100%;">
                    <div class="card-body">
                        <h3 class="card-title">{{ $book->title }}</h3>
                        <p class="card-sub">{{ $book->excerpt ?: \Illuminate\Support\Str::limit($book->description ?? '', 110, '...') }}</p>
                        <div class="row" style="align-items:center;justify-content:space-between;">
                            <span class="price">{{ $currency }}{{ number_format($book->price/100, 2) }}</span>
                            @if($book->type)
                                <span class="small" style="color:var(--muted);">{{ ucfirst($book->type) }}</span>
                            @endif
                        </div>
                        <div class="row mt-2" style="gap:.5rem;flex-wrap:wrap;">
                            <a class="btn btn-outline" href="{{ route('books.show', $book->slug) }}">{{ $siteSettings->get('content.books.view_button_label', 'View') }}</a>
                            <form action="{{ route('cart.add', $book->slug) }}" method="post" style="margin:0;">
                                @csrf
                                <input type="hidden" name="qty" value="1">
                                <button class="btn btn-primary" type="submit">{{ $siteSettings->get('content.books.add_button_label', 'Add') }}</button>
                            </form>
                        </div>
                    </div>
                </article>
            @empty
                <p class="small">New releases are brewing behind the scenes. Check back soon.</p>
            @endforelse
        </div>
        <div class="mt-3">
            <a class="btn btn-primary" href="{{ route('books.index') }}">{{ $siteSettings->get('content.home.view_all_label', 'Explore the full shelf') }}</a>
        </div>
    </div>
</section>

<section class="section reveal">
    <div class="container grid grid-2">
        <div>
            <h2 class="mt-0">{{ $homeContent['about_title'] ?? 'About the author' }}</h2>
            <p>{{ $homeContent['about_body'] ?? 'We champion stories and resources that make readers feel braver, calmer, and more connected.' }}</p>
            <a class="btn btn-primary mt-2" href="{{ route('about') }}">{{ $homeContent['about_cta_label'] ?? 'Learn more' }}</a>
        </div>
        <div class="card center promo-swing reveal">
            <div class="card-body">
                <div class="badge-pill">{{ $homeContent['promo_badge'] ?? 'Upcoming' }}</div>
                <h3 class="mt-2">{{ $homeContent['promo_title'] ?? 'Sky Lantern Notes' }}</h3>
                <p>{{ $homeContent['promo_body'] ?? 'Short reflections for calm, focus, and courage. Join the launch list to enjoy first-look chapters and preorder bonuses.' }}</p>
                <a class="btn btn-outline" href="{{ route('promotions.index') }}">{{ $siteSettings->get('content.home.promo_cta_label', 'Get updates') }}</a>
            </div>
        </div>
    </div>
</section>

<section class="section stripe reveal">
    <div class="container">
        <h2 class="mt-0">{{ $homeContent['testimonials_title'] ?? 'What readers say' }}</h2>
        <div class="grid grid-3 mt-2">
            @foreach([1,2,3] as $index)
                @php
                    $quote = $homeContent['testimonial_' . $index . '_quote'] ?? null;
                    $name = $homeContent['testimonial_' . $index . '_name'] ?? null;
                @endphp
                @if($quote && $name)
                    <div class="card reveal"><div class="card-body"><p>{{ $quote }}</p><p class="small">� {{ $name }}</p></div></div>
                @endif
            @endforeach
        </div>
    </div>
</section>

@if($posts->isNotEmpty())
<section class="section reveal">
    <div class="container">
        <div class="row" style="justify-content:space-between;align-items:flex-end;gap:1rem;flex-wrap:wrap;">
            <div>
                <h2 class="mt-0">{{ $homeContent['blog_title'] ?? 'Fresh from the blog' }}</h2>
                <p class="small">{{ $homeContent['blog_subheading'] ?? 'Practical tips and behind-the-pages reflections.' }}</p>
            </div>
            <a class="btn btn-outline" href="{{ route('blog.index') }}">{{ $siteSettings->get('content.home.blog_cta_label', 'View all posts') }}</a>
        </div>
        <div class="grid grid-3 mt-2">
            @foreach($posts as $post)
                <article class="card reveal">
                    <div class="card-body">
                        <h3 class="card-title">{{ $post->title }}</h3>
                        <p class="card-sub">{{ $post->excerpt }}</p>
                        <a class="btn btn-primary mt-2" href="{{ route('blog.show', $post->slug) }}">{{ $siteSettings->get('content.blog.read_story_label', 'Read story') }}</a>
                    </div>
                </article>
            @endforeach
        </div>
    </div>
</section>
@endif

<section class="section stripe reveal">
    <div class="container grid grid-2">
        <div>
            <h2 class="mt-0">{{ $homeContent['newsletter_title'] ?? "Let's stay in touch" }}</h2>
            <p>{{ $homeContent['newsletter_body'] ?? 'Get launch invites, giveaways, and reading prompts straight to your inbox.' }}</p>
            <form class="mt-3" action="{{ route('newsletter.subscribe') }}" method="post">
                @csrf
                <div class="form-row">
                    <input class="input" type="email" name="email" placeholder="you@example.com" required aria-label="Email">
                    <button class="btn btn-primary" type="submit">{{ $siteSettings->get('content.home.newsletter_cta_label', 'Subscribe') }}</button>
                </div>
                <p class="small mt-1">{{ $siteSettings->get('content.footer_newsletter_hint', 'No spam. Unsubscribe anytime.') }}</p>
            </form>
        </div>
        <div>
            <h2 class="mt-0">{{ $homeContent['contact_title'] ?? 'Share a quick note' }}</h2>
            <p>{{ $homeContent['contact_body'] ?? "Have an event idea or want to collaborate? Leave a message and we'll get back to you." }}</p>
            <form class="mt-3" action="{{ route('contact.send') }}" method="post">
                @csrf
                <input class="input" type="text" name="name" placeholder="Your name" required>
                <div class="form-row mt-2">
                    <input class="input" type="email" name="email" placeholder="Your email" required>
                </div>
                <textarea class="textarea mt-2" name="message" rows="4" placeholder="How can we help?" required></textarea>
                <button class="btn btn-outline mt-2" type="submit">{{ $siteSettings->get('content.contact.form_submit_label', 'Send message') }}</button>
            </form>
        </div>
    </div>
</section>
@endsection
