@extends('layouts.site')

@php $newsletterContent = $siteSettings->content('newsletter'); @endphp
@section('title', 'Newsletter Confirmed')
@section('meta_description', $newsletterContent['confirmed_body'] ?? 'You are now subscribed to the BrightQuill newsletter.')

@section('content')
<section class="section reveal">
    <div class="container" style="max-width:640px;text-align:center;">
        <div class="badge-pill">{{ $newsletterContent['confirmed_badge'] ?? "You're in" }}</div>
        <h1 class="mt-2">{{ $newsletterContent['confirmed_title'] ?? 'Subscription confirmed' }}</h1>
        <p>{{ str_replace(':email', $subscriber->email, $newsletterContent['confirmed_body'] ?? 'Thanks, :email. Expect essays, launch updates, and surprise giveaways in your inbox soon.') }}</p>
        <a class="btn btn-primary mt-3" href="{{ route('home') }}">{{ $newsletterContent['confirmed_cta_label'] ?? 'Return home' }}</a>
    </div>
</section>
@endsection
