@extends('layouts.site')

@php $newsletterContent = $siteSettings->content('newsletter'); @endphp
@section('title', 'Unsubscribed')
@section('meta_description', $newsletterContent['unsub_body'] ?? 'You have been unsubscribed from the BrightQuill newsletter.')

@section('content')
<section class="section reveal">
    <div class="container" style="max-width:640px;text-align:center;">
        <div class="badge-pill">{{ $newsletterContent['unsub_badge'] ?? 'Update saved' }}</div>
        <h1 class="mt-2">{{ $newsletterContent['unsub_title'] ?? "You're unsubscribed" }}</h1>
        <p>{{ str_replace(':email', $subscriber->email, $newsletterContent['unsub_body'] ?? ':email, we will stop sending newsletter emails. You are always welcome back whenever you miss us.') }}</p>
        <a class="btn btn-outline mt-3" href="{{ route('home') }}">{{ $newsletterContent['unsub_cta_label'] ?? 'Return home' }}</a>
    </div>
</section>
@endsection
