@extends('layouts.site')

@section('title', 'Promotions')
@php $promotionsContent = $siteSettings->content('promotions'); @endphp
@section('meta_description', $promotionsContent['index_intro'] ?? 'Special giveaways, launch bonuses, and community events hosted by BrightQuill.')

@section('content')
<section class="section reveal">
    <div class="container">
        <h1 class="mt-0">{{ $promotionsContent['index_title'] ?? 'Current promotions' }}</h1>
        <p>{{ $promotionsContent['index_intro'] ?? 'Limited-time treats for readers and creative partners. Enter below and share with your book club.' }}</p>
        <div class="grid grid-3 mt-2">
            @foreach($promotions as $promotion)
                <article class="card reveal">
                    <div class="card-body">
                        <div class="badge-pill">Code: {{ $promotion->code }}</div>
                        <h3 class="card-title">{{ $promotion->title }}</h3>
                        <p class="card-sub">{{ \Illuminate\Support\Str::limit($promotion->description, 120, '...') }}</p>
                        <a class="btn btn-primary mt-2" href="{{ route('promotions.show', $promotion->code) }}">{{ $promotionsContent['view_details_label'] ?? 'View details' }}</a>
                    </div>
                </article>
            @endforeach
        </div>
        <div class="mt-3">{{ $promotions->links() }}</div>
    </div>
</section>
@endsection
