@extends('layouts.site')

@section('title', $promotion->title)
@php $promotionsContent = $siteSettings->content('promotions'); @endphp
@section('meta_description', \Illuminate\Support\Str::limit($promotion->description, 140, '...'))

@section('content')
<section class="section reveal">
    <div class="container" style="max-width:760px;">
        <div class="badge-pill">{{ $promotionsContent['enter_title'] ?? 'Promotion' }}</div>
        <h1 class="mt-2">{{ $promotion->title }}</h1>
        <p class="lead">Use code <strong>{{ $promotion->code }}</strong> @if($promotion->ends_at) before {{ $promotion->ends_at->format('M j, Y') }} @endif.</p>
        <article class="mt-2" style="line-height:1.8;">{!! nl2br(e($promotion->description)) !!}</article>
        <form class="card mt-3" action="{{ route('promotions.enter', $promotion->code) }}" method="post">
            <div class="card-body">
                <h2 class="card-title">{{ $promotionsContent['enter_title'] ?? 'Enter giveaway' }}</h2>
                @csrf
                <label class="small" for="entry-name">Name</label>
                <input class="input mt-1" id="entry-name" name="name" type="text" required>
                <label class="small mt-3" for="entry-email">Email</label>
                <input class="input mt-1" id="entry-email" name="email" type="email" required>
                <button class="btn btn-primary mt-3" type="submit">{{ $promotionsContent['enter_submit_label'] ?? 'Submit entry' }}</button>
            </div>
        </form>
    </div>
</section>
@endsection
