const fs = require('fs');
const path = require('path');
const { Country, State } = require('country-state-city');

const countries = Country.getAllCountries();
const payload = countries.map((country) => {
  const states = State.getStatesOfCountry(country.isoCode || country.iso2 || country.isoCode3 || country.iso).map((state) => ({
    code: state.isoCode || state.isoCode3 || state.state_code || state.iso,
    name: state.name,
  })).filter((state) => state.code && state.name);

  return {
    code: country.isoCode || country.iso2 || country.iso || country.isoCode3,
    name: country.name,
    states,
  };
}).filter((country) => country.code && country.name);

const outputPath = path.resolve(__dirname, '../resources/data/countries_states.json');
fs.mkdirSync(path.dirname(outputPath), { recursive: true });
fs.writeFileSync(outputPath, JSON.stringify(payload, null, 2));
console.log(`Wrote ${payload.length} countries to ${outputPath}`);
