﻿<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(config('app.name', 'Author Bookstore')); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&family=Playfair+Display:wght@600;700&display=swap" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        :root{ --bg:#ffffff; --fg:#1f2937; --primary:#01637A; --accent:#fcb900; --muted:#6b7280; }
        body{background:var(--bg); color:var(--fg); font-family:Inter, system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif}
        .heading{font-family:"Playfair Display", Georgia, serif}
        .btn-primary{background:var(--primary); color:white}
        .btn-primary:hover{opacity:.9}
        .link:hover{color:var(--primary)}
        .reveal{opacity:0; transform:translateY(24px); transition:opacity .7s ease, transform .7s ease; transition-delay: var(--delay, 0s)}
        .reveal.is-visible{opacity:1; transform:none}
        [data-animate="up"].reveal{transform:translateY(24px)}
        [data-animate="left"].reveal{transform:translateX(-32px)}
        [data-animate="right"].reveal{transform:translateX(32px)}
        [data-animate="zoom"].reveal{transform:scale(.96)}
    </style>
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link rel="stylesheet" href="https://unpkg.com/aos@2.3.4/dist/aos.css">
    <script defer src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function(){
        if (window.AOS) { AOS.init({ once: true, offset: 80, duration: 700, easing: 'ease-out-quart' }); }
        try {
            const io = new IntersectionObserver((entries)=>{ entries.forEach(e=>{ if(e.isIntersecting){ e.target.classList.add('is-visible'); io.unobserve(e.target);} }); }, {threshold:0.15});
            document.querySelectorAll('[data-stagger] .reveal').forEach((el,i)=> el.style.setProperty('--delay', (i*0.08)+'s'));
            document.querySelectorAll('.reveal:not([data-aos])').forEach(el=> io.observe(el));
        } catch(e){}
    });
    </script>
</head>
<body class="min-h-full flex flex-col">
    <div class="text-xs bg-gray-50 text-gray-600 py-1">
        <div class="max-w-6xl mx-auto px-4 flex justify-between">
            <div class="flex gap-3"><span>Twitter</span><span>Instagram</span><span>Facebook</span></div>
            <div>Contact: hello@example.com</div>
        </div>
    </div>
    <?php if(session('toast')): ?>
    <div x-data="{ show:true }" x-show="show" x-transition class="fixed top-4 right-4 bg-slate-900 text-white text-sm rounded px-4 py-2 shadow-lg z-50">
        <div class="flex items-center gap-3">
            <span><?php echo e(session('toast')); ?></span>
            <button class="opacity-70 hover:opacity-100" @click="show=false">&times;</button>
        </div>
    </div>
    <?php endif; ?>
    <?php if(auth()->guard()->check()): ?>
        <?php if(is_null(auth()->user()->email_verified_at)): ?>
        <div class="bg-yellow-50 border-b border-yellow-200">
            <div class="max-w-6xl mx-auto px-4 py-2 text-sm text-yellow-900 flex items-center justify-between">
                <div>
                    Please verify your email to access checkout and other features.
                    <?php if(session('status') === 'verification-link-sent'): ?>
                        <span class="ml-2 text-green-700">Verification link sent.</span>
                    <?php endif; ?>
                </div>
                <form method="post" action="<?php echo e(route('verification.send')); ?>">
                    <?php echo csrf_field(); ?>
                    <button class="underline">Resend verification email</button>
                </form>
            </div>
        </div>
        <?php endif; ?>
    <?php endif; ?>
    <header class="sticky top-0 z-40 bg-white/95 backdrop-blur border-b border-gray-200">
        <div class="max-w-6xl mx-auto px-4">
            <div class="flex items-center justify-between h-16">
                <a href="<?php echo e(route('home')); ?>" class="heading text-xl text-ink">Author Bookstore</a>
                <nav class="hidden md:flex gap-6 text-sm text-ink">
                    <a href="<?php echo e(route('home')); ?>" class="link">Home</a>
                    <a href="<?php echo e(route('about')); ?>" class="link">About</a>
                    <a href="<?php echo e(route('books.index')); ?>" class="link">Books</a>
                    <a href="<?php echo e(route('promotions.index')); ?>" class="link">Promotions</a>
                    <a href="<?php echo e(route('services')); ?>" class="link">Services &amp; Tools</a>
                    <a href="<?php echo e(route('blog.index')); ?>" class="link">Blogs</a>
                    <a href="<?php echo e(route('merch')); ?>" class="link">Merch</a>
                    <a href="<?php echo e(route('contact.show')); ?>" class="link">Contact</a>
                    <?php if(auth()->guard()->guest()): ?>
                        <a href="<?php echo e(route('login')); ?>" class="link">Login</a>
                        <a href="<?php echo e(route('register')); ?>" class="link">Register</a>
                    <?php endif; ?>
                </nav>
                <div class="flex items-center gap-4">
                    <?php if(auth()->guard()->guest()): ?>
                        <a href="<?php echo e(route('login')); ?>" class="text-sm link">Login</a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('cart.index')); ?>" class="text-sm text-ink"><?php echo e(config('payment.currency_symbol', '$')); ?><?php echo e(number_format(($cartSummary['totalKobo'] ?? 0)/100, 2)); ?> &bull; <?php echo e($cartSummary['qty'] ?? 0); ?> Cart</a>
                </div>
            </div>
        </div>
    </header>

    <main class="flex-1">
        <?php echo e($slot ?? ''); ?>

        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <footer class="mt-16 border-t border-gray-200 bg-gray-50">
        <div class="max-w-6xl mx-auto px-4 py-12 grid md:grid-cols-4 gap-8 text-sm text-gray-600">
            <div>
                <div class="heading text-lg mb-3 text-ink">Quick Links</div>
                <ul class="space-y-2">
                    <li><a href="<?php echo e(route('books.index')); ?>" class="link">Books</a></li>
                    <li><a href="<?php echo e(route('blog.index')); ?>" class="link">Blog</a></li>
                    <li><a href="<?php echo e(route('promotions.index')); ?>" class="link">Promotions</a></li>
                    <li><a href="<?php echo e(route('contact.show')); ?>" class="link">Contact</a></li>
                    <?php if(auth()->guard()->guest()): ?>
                        <li><a href="<?php echo e(route('login')); ?>" class="link">Login</a></li>
                        <li><a href="<?php echo e(route('register')); ?>" class="link">Create Account</a></li>
                    <?php endif; ?>
                </ul>
            </div>
            <div>
                <div class="heading text-lg mb-3 text-ink">Newsletter</div>
                <form action="<?php echo e(route('newsletter.subscribe')); ?>" method="post" class="flex gap-2">
                    <?php echo csrf_field(); ?>
                    <input name="email" required type="email" placeholder="you@example.com" class="bg-white border border-gray-300 rounded px-3 py-2 w-full" />
                    <button class="btn-primary font-semibold px-4 rounded">Subscribe</button>
                </form>
            </div>
            <div>
                <div class="heading text-lg mb-3 text-ink">Contact</div>
                <div class="text-ink/80">hello@example.com</div>
            </div>
            <div class="text-gray-500">&copy; <?php echo e(date('Y')); ?> Author Bookstore</div>
        </div>
    </footer>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\book_store\resources\views/layouts/app.blade.php ENDPATH**/ ?>