<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <script>document.documentElement.classList.add('js');</script>
    <?php
        $appearance = $siteSettings->appearance();
        $typography = $siteSettings->typography();
        $metaDescription = trim($__env->yieldContent('meta_description'));
        if ($metaDescription === '') {
            $metaDescription = $siteSettings->get('content.footer_tagline', 'BrightQuill offers curated stories, promotions, and creative tools for curious readers and indie authors.');
        }
        $logoPath = $siteSettings->get('brand.logo_path');
        $faviconPath = $siteSettings->get('brand.favicon_path');
        $logoUrl = $logoPath ? \Illuminate\Support\Facades\Storage::disk('public')->url($logoPath) : null;
        $faviconUrl = $faviconPath ? \Illuminate\Support\Facades\Storage::disk('public')->url($faviconPath) : asset('favicon.ico');
        $faviconType = $faviconPath && str_ends_with(strtolower($faviconPath), '.ico') ? 'image/x-icon' : 'image/png';

        $brightQuillStyles = asset('brightquill/assets/styles.css');
        $brightQuillScripts = asset('brightquill/assets/scripts.js');

        if (file_exists(public_path('brightquill/assets/styles.css'))) {
            $brightQuillStyles .= '?v=' . filemtime(public_path('brightquill/assets/styles.css'));
        }

        if (file_exists(public_path('brightquill/assets/scripts.js'))) {
            $brightQuillScripts .= '?v=' . filemtime(public_path('brightquill/assets/scripts.js'));
        }
    ?>
    <title>
        <?php if (! empty(trim($__env->yieldContent('title')))): ?>
            <?php echo $__env->yieldContent('title'); ?> | <?php echo e(config('app.name', 'BrightQuill')); ?>

        <?php else: ?>
            <?php echo e(config('app.name', 'BrightQuill')); ?>

        <?php endif; ?>
    </title>
    <meta name="description" content="<?php echo e($metaDescription); ?>">
    <link rel="icon" type="<?php echo e($faviconType); ?>" href="<?php echo e($faviconUrl); ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <?php if(!empty($typography['font_embed_url'])): ?>
        <link rel="stylesheet" href="<?php echo e($typography['font_embed_url']); ?>">
    <?php endif; ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <link rel="stylesheet" href="<?php echo e($brightQuillStyles); ?>">
    <style>
        :root{
            --primary: <?php echo e($appearance['primary_color'] ?? '#1A4D8F'); ?>;
            --primary-600: <?php echo e($appearance['primary_alt_color'] ?? '#153F74'); ?>;
            --accent: <?php echo e($appearance['accent_color'] ?? '#F5B82E'); ?>;
            --bg: <?php echo e($appearance['background_color'] ?? '#FFFFFF'); ?>;
            --surface: <?php echo e($appearance['surface_color'] ?? '#F4F4F4'); ?>;
            --ink: <?php echo e($appearance['text_color'] ?? '#222222'); ?>;
            --muted: <?php echo e($appearance['muted_text_color'] ?? '#64748B'); ?>;
            --line: <?php echo e($appearance['line_color'] ?? '#E2E8F0'); ?>;
        }
        body{background:var(--bg); color:var(--ink); font-family:"<?php echo e($typography['body_font'] ?? 'Poppins'); ?>", Inter, ui-sans-serif, system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif}
        .heading{font-family:"<?php echo e($typography['heading_font'] ?? 'Merriweather'); ?>", Georgia, serif}
        .brand-logo-img{height:44px;width:auto;border-radius:12px;object-fit:contain;background:#fff;padding:4px;box-shadow:0 4px 12px rgba(0,0,0,0.08)}
        #splash{position:fixed;inset:0;background:<?php echo e($appearance['primary_color'] ?? '#1A4D8F'); ?>;display:grid;place-items:center;z-index:80}
        #splash .logo{color:<?php echo e($appearance['accent_color'] ?? '#F5B82E'); ?>;font-family:"<?php echo e($typography['heading_font'] ?? 'Merriweather'); ?>", Georgia, serif;font-weight:900;font-size:clamp(1.8rem,4vw,3rem);letter-spacing:.5px;animation:splashZoomBounce .9s ease both}
        #splash.hide{animation: fadeOut .45s ease forwards}
        @keyframes fadeOut{to{opacity:0;visibility:hidden}}
        .navlinks form{display:inline}
        .navlinks form button{border:none;background:none;padding:.55rem .8rem;border-radius:12px;font:inherit;color:inherit;cursor:pointer}
        .navlinks form button:hover{background:var(--surface);color:var(--primary)}
        .drawer form{margin-top:1rem}
        .drawer form button{width:100%;border:none;background:<?php echo e($appearance['primary_color'] ?? '#1A4D8F'); ?>;color:#fff;padding:.75rem;border-radius:12px;font-weight:700;cursor:pointer}
        .drawer a.badge{display:flex;align-items:center;justify-content:space-between;gap:.5rem}
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <div id="splash" aria-hidden="true">
        <div class="logo"><?php echo e(config('app.name', 'BrightQuill')); ?></div>
    </div>

    <?php
        $headerTagline = $siteSettings->get('content.header_tagline');
    ?>
    <header class="header" role="banner">
        <div class="container nav" role="navigation" aria-label="Main">
            <a class="brand" href="<?php echo e(route('home')); ?>">
                <?php if($logoUrl): ?>
                    <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e(config('app.name', 'BrightQuill')); ?> logo" class="brand-logo-img">
                <?php else: ?>
                    <span class="brand-logo" aria-hidden="true"></span>
                <?php endif; ?>
                <span class="brand-name"><?php echo e(config('app.name', 'BrightQuill')); ?></span>
            </a>
            <nav class="navlinks" aria-label="Primary">
                <a href="<?php echo e(route('home')); ?>" aria-current="<?php echo e(request()->routeIs('home') ? 'page' : 'false'); ?>">Home</a>
                <a href="<?php echo e(route('about')); ?>" aria-current="<?php echo e(request()->routeIs('about') ? 'page' : 'false'); ?>">About</a>
                <a href="<?php echo e(route('books.index')); ?>" aria-current="<?php echo e(request()->routeIs('books.*') ? 'page' : 'false'); ?>">Books</a>
                <a href="<?php echo e(route('promotions.index')); ?>" aria-current="<?php echo e(request()->routeIs('promotions.*') ? 'page' : 'false'); ?>">Promotions</a>
                <a href="<?php echo e(route('services')); ?>" aria-current="<?php echo e(request()->routeIs('services') ? 'page' : 'false'); ?>">Services &amp; Tools</a>
                <a href="<?php echo e(route('blog.index')); ?>" aria-current="<?php echo e(request()->routeIs('blog.*') ? 'page' : 'false'); ?>">Blog</a>
                <a href="<?php echo e(route('merch')); ?>" aria-current="<?php echo e(request()->routeIs('merch') ? 'page' : 'false'); ?>">Merch</a>
                <a href="<?php echo e(route('contact.show')); ?>" aria-current="<?php echo e(request()->routeIs('contact.*') ? 'page' : 'false'); ?>">Contact</a>
                <a class="badge" href="<?php echo e(route('cart.index')); ?>" aria-current="<?php echo e(request()->routeIs('cart.index') ? 'page' : 'false'); ?>" aria-label="Cart with <?php echo e($cartSummary['qty'] ?? 0); ?> items worth <?php echo e(config('payment.currency_symbol', '$')); ?><?php echo e(number_format(($cartSummary['totalKobo'] ?? 0)/100, 2)); ?>">
                    Cart
                    <span class="count"><?php echo e($cartSummary['qty'] ?? 0); ?></span>
                </a>
            </nav>
            <button class="menu-btn" aria-haspopup="dialog" aria-expanded="false" type="button">Menu</button>
        </div>
        <?php if(!empty($headerTagline)): ?>
            <div class="container" style="padding:0 1rem 0.8rem 1rem; font-size:0.85rem; color:var(--muted);">
                <p class="hidden md:block"><?php echo e($headerTagline); ?></p>
            </div>
        <?php endif; ?>
        <div class="drawer" role="dialog" aria-modal="true">
            <div class="drawer-panel">
                <nav class="drawer-links" aria-label="Mobile">
                    <a href="<?php echo e(route('home')); ?>" aria-current="<?php echo e(request()->routeIs('home') ? 'page' : 'false'); ?>">Home</a>
                    <a href="<?php echo e(route('about')); ?>" aria-current="<?php echo e(request()->routeIs('about') ? 'page' : 'false'); ?>">About</a>
                    <a href="<?php echo e(route('books.index')); ?>" aria-current="<?php echo e(request()->routeIs('books.*') ? 'page' : 'false'); ?>">Books</a>
                    <a href="<?php echo e(route('promotions.index')); ?>" aria-current="<?php echo e(request()->routeIs('promotions.*') ? 'page' : 'false'); ?>">Promotions</a>
                    <a href="<?php echo e(route('services')); ?>" aria-current="<?php echo e(request()->routeIs('services') ? 'page' : 'false'); ?>">Services &amp; Tools</a>
                    <a href="<?php echo e(route('blog.index')); ?>" aria-current="<?php echo e(request()->routeIs('blog.*') ? 'page' : 'false'); ?>">Blog</a>
                    <a href="<?php echo e(route('merch')); ?>" aria-current="<?php echo e(request()->routeIs('merch') ? 'page' : 'false'); ?>">Merch</a>
                    <a class="badge" href="<?php echo e(route('cart.index')); ?>" aria-current="<?php echo e(request()->routeIs('cart.index') ? 'page' : 'false'); ?>">
                        Cart
                        <span class="count"><?php echo e($cartSummary['qty'] ?? 0); ?></span>
                    </a>
                    <a href="<?php echo e(route('contact.show')); ?>" aria-current="<?php echo e(request()->routeIs('contact.*') ? 'page' : 'false'); ?>">Contact</a>
                </nav>
            </div>
        </div>
    </header>

    <?php
        $flashMessage = session('toast') ?? session('status') ?? session('success') ?? session('message');
    ?>

    <main>
        <?php echo e($slot ?? ''); ?>

        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <?php
        $footerQuickLinks = $siteSettings->get('content.footer_quick_links_title', 'Quick Links');
        $footerNewsletter = $siteSettings->get('content.footer_newsletter_title', 'Newsletter');
        $footerHint = $siteSettings->get('content.footer_newsletter_hint', 'No spam. Unsubscribe anytime.');
        $footerTagline = $siteSettings->get('content.footer_tagline');
    ?>
    <footer class="footer">
        <div class="container footer-grid">
            <div>
                <div class="brand" style="margin-bottom:.75rem">
                    <?php if($logoUrl): ?>
                        <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e(config('app.name', 'BrightQuill')); ?> logo" class="brand-logo-img">
                    <?php else: ?>
                        <span class="brand-logo" aria-hidden="true"></span>
                    <?php endif; ?>
                    <span class="brand-name"><?php echo e(config('app.name', 'BrightQuill')); ?></span>
                </div>
                <p class="small"><?php echo e($footerTagline); ?></p>
            </div>
            <div>
                <strong><?php echo e($footerQuickLinks); ?></strong>
                <div class="mt-2">
                    <div><a href="<?php echo e(route('books.index')); ?>">Browse Books</a></div>
                    <div><a href="<?php echo e(route('blog.index')); ?>">Read the Blog</a></div>
                    <div><a href="<?php echo e(route('promotions.index')); ?>">Promotions</a></div>
                    <div><a href="<?php echo e(route('contact.show')); ?>">Contact</a></div>
                    <?php if(Route::has('login')): ?>
                        <div>
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(route('admin.dashboard')); ?>">Admin</a>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>">Login</a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div>
                <strong><?php echo e($footerNewsletter); ?></strong>
                <form class="mt-2" action="<?php echo e(route('newsletter.subscribe')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <input required class="input" type="email" name="email" placeholder="you@example.com" aria-label="Email">
                    <button class="btn btn-primary mt-2" type="submit">Subscribe</button>
                    <p class="small mt-1"><?php echo e($footerHint); ?></p>
                </form>
            </div>
        </div>
        <div class="container small" style="padding:.75rem 0;border-top:1px solid var(--line)">
            &copy; <?php echo e(now()->year); ?> <?php echo e(config('app.name', 'BrightQuill')); ?>. All rights reserved.
        </div>
    </footer>

    <div class="toast" role="status" aria-live="polite"></div>

    <script>
        window.brightQuill = {
            cartCount: <?php echo e($cartSummary['qty'] ?? 0); ?>,
            cartTotal: "<?php echo e(config('payment.currency_symbol', '$')); ?><?php echo e(number_format(($cartSummary['totalKobo'] ?? 0)/100, 2)); ?>"
        };
    </script>
    <script src="<?php echo e($brightQuillScripts); ?>"></script>
    <?php if($flashMessage): ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                if (typeof toast === 'function') {
                    toast(<?php echo json_encode($flashMessage, 15, 512) ?>);
                }
            });
        </script>
    <?php endif; ?>
    <?php if($errors->any()): ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                if (typeof toast === 'function') {
                    toast(<?php echo json_encode($errors->first(), 15, 512) ?>);
                }
            });
        </script>
    <?php endif; ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>




<?php /**PATH C:\xampp\htdocs\book_store\resources\views/layouts/site.blade.php ENDPATH**/ ?>