

<?php $__env->startSection('title', 'Checkout'); ?>
<?php
    use App\Support\CountryRepository;

    $checkoutContent = $siteSettings->content('checkout');
    $countryStateMap = CountryRepository::countries()
        ->mapWithKeys(fn ($country) => [
            $country['code'] => CountryRepository::subdivisions($country['code'])->map(fn ($sub) => [
                'code' => $sub['code'],
                'name' => $sub['name'],
            ])->values(),
        ])
        ->filter(fn ($states) => $states->isNotEmpty())
        ->map(fn ($states) => $states->values());
?>
<?php $__env->startSection('meta_description', $checkoutContent['contact_intro'] ?? 'Secure checkout for your BrightQuill order.'); ?>

<?php
    $currency = $currencySymbol ?? config('payment.currency_symbol', '$');
?>

<?php $__env->startSection('content'); ?>
<section class="section reveal">
    <div class="container grid grid-2">
        <form id="intentForm" class="card reveal">
            <div class="card-body">
                <h1 class="mt-0"><?php echo e($checkoutContent['contact_title'] ?? 'Contact & delivery'); ?></h1>
                <p class="card-sub"><?php echo e($checkoutContent['contact_intro'] ?? 'Tell us where to send digital receipts and goodies.'); ?></p>
                <label class="small" for="name">Name</label>
                <input class="input mt-1" id="name" name="name" type="text" required>
                <label class="small mt-3" for="email">Email</label>
                <input class="input mt-1" id="email" name="email" type="email" required>
                <label class="small mt-3" for="line1">Address</label>
                <input class="input mt-1" id="line1" name="address[line1]" type="text" required>
                <div class="grid" style="grid-template-columns:1fr 1fr;gap:0.75rem;margin-top:0.75rem;">
                    <div>
                        <label class="small" for="city">City</label>
                        <input class="input mt-1" id="city" name="address[city]" type="text" required>
                    </div>
                    <div>
                        <label class="small" for="state">State / region</label>
                        <?php if (isset($component)) { $__componentOriginalef4361d61a244186737e0ed10e0792dd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalef4361d61a244186737e0ed10e0792dd = $attributes; } ?>
<?php $component = App\View\Components\SelectState::resolve(['id' => 'state','name' => 'address[state]','country' => old('address.country', 'US'),'placeholder' => 'Select state / region (optional)','value' => old('address.state')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('select-state'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\SelectState::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-1']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalef4361d61a244186737e0ed10e0792dd)): ?>
<?php $attributes = $__attributesOriginalef4361d61a244186737e0ed10e0792dd; ?>
<?php unset($__attributesOriginalef4361d61a244186737e0ed10e0792dd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalef4361d61a244186737e0ed10e0792dd)): ?>
<?php $component = $__componentOriginalef4361d61a244186737e0ed10e0792dd; ?>
<?php unset($__componentOriginalef4361d61a244186737e0ed10e0792dd); ?>
<?php endif; ?>
                    </div>
                </div>
                <div class="grid" style="grid-template-columns:1fr 1fr;gap:0.75rem;margin-top:0.75rem;">
                    <div>
                        <label class="small" for="postal">Postal code</label>
                        <input class="input mt-1" id="postal" name="address[postal_code]" type="text">
                    </div>
                    <div>
                        <label class="small" for="country">Country</label>
                        <?php if (isset($component)) { $__componentOriginalb79f6f5d5baacb046fc793ffa17c586e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb79f6f5d5baacb046fc793ffa17c586e = $attributes; } ?>
<?php $component = App\View\Components\SelectCountry::resolve(['id' => 'country','name' => 'address[country]','placeholder' => 'Select country','value' => old('address.country', 'US'),'required' => true] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('select-country'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\SelectCountry::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-1']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb79f6f5d5baacb046fc793ffa17c586e)): ?>
<?php $attributes = $__attributesOriginalb79f6f5d5baacb046fc793ffa17c586e; ?>
<?php unset($__attributesOriginalb79f6f5d5baacb046fc793ffa17c586e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb79f6f5d5baacb046fc793ffa17c586e)): ?>
<?php $component = $__componentOriginalb79f6f5d5baacb046fc793ffa17c586e; ?>
<?php unset($__componentOriginalb79f6f5d5baacb046fc793ffa17c586e); ?>
<?php endif; ?>
                    </div>
                </div>
                <button class="btn btn-primary mt-3" type="submit"><?php echo e($siteSettings->get('content.checkout.continue_label', 'Continue to payment')); ?></button>
            </div>
        </form>
        <aside class="card reveal">
            <div class="card-body">
                <h2 class="card-title"><?php echo e($checkoutContent['order_summary_title'] ?? 'Order summary'); ?></h2>
                <ul class="mt-2" style="list-style:none;padding:0;margin:0;">
                    <?php $__currentLoopData = ($cart['items'] ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="row" style="justify-content:space-between;gap:0.75rem;margin-bottom:.75rem;">
                            <div>
                                <span><?php echo e($item['title']); ?> &times; <?php echo e($item['qty']); ?></span>
                                <?php if(($item['shipping_fee_kobo'] ?? 0) > 0): ?>
                                    <div class="text-xs text-slate-500">Shipping: <?php echo e($currency); ?><?php echo e(number_format(($item['shipping_fee_kobo'] ?? 0) * $item['qty'] / 100, 2)); ?></div>
                                <?php endif; ?>
                            </div>
                            <span><?php echo e($currency); ?><?php echo e(number_format(($item['price_kobo'] ?? 0) * $item['qty'] / 100, 2)); ?></span>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div class="separator"></div>
                <div class="row" style="justify-content:space-between;align-items:center;">
                    <span class="text-sm text-slate-500"><?php echo e($checkoutContent['subtotal_label'] ?? 'Subtotal'); ?></span>
                    <span><?php echo e($currency); ?><?php echo e(number_format(($cart['subtotalKobo'] ?? 0)/100, 2)); ?></span>
                </div>
                <?php if(($cart['shippingKobo'] ?? 0) > 0): ?>
                    <div class="row" style="justify-content:space-between;align-items:center;">
                        <span class="text-sm text-slate-500"><?php echo e($checkoutContent['shipping_label'] ?? 'Shipping'); ?></span>
                        <span><?php echo e($currency); ?><?php echo e(number_format(($cart['shippingKobo'] ?? 0)/100, 2)); ?></span>
                    </div>
                <?php endif; ?>
                <div class="row" style="justify-content:space-between;align-items:center;font-weight:700;">
                    <span><?php echo e($checkoutContent['total_label'] ?? 'Total'); ?></span>
                    <span><?php echo e($currency); ?><?php echo e(number_format(($cart['totalKobo'] ?? 0)/100, 2)); ?></span>
                </div>
                <div id="payActions" class="mt-3" style="display:none;">
                    <button id="payStripe" class="btn btn-primary" type="button" style="width:100%;"><?php echo e($checkoutContent['stripe_label'] ?? 'Pay with Stripe'); ?></button>
                    <button id="payPaypal" class="btn btn-outline mt-2" type="button" style="width:100%;"><?php echo e($checkoutContent['paypal_label'] ?? 'Pay with PayPal'); ?></button>
                </div>
            </div>
        </aside>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
const checkoutCountryStates = <?php echo json_encode($countryStateMap, 15, 512) ?>;
const countrySelect = document.getElementById('country');
const stateSelect = document.getElementById('state');
const statePlaceholderText = stateSelect ? stateSelect.dataset.placeholder || 'Select state / region' : 'Select state / region';
const stateFallbackText = stateSelect ? stateSelect.dataset.fallback || 'Not required for this country' : 'Not required for this country';
const initialStateValue = stateSelect ? stateSelect.value : '';

const normalize = (value) => (value || '').toString().trim().toUpperCase();

function hydrateStateOptions(countryCode, preserveSelection = true) {
    if (!stateSelect) return;

    const normalizedCountry = normalize(countryCode);
    const options = checkoutCountryStates[normalizedCountry] || [];
    const previousValue = preserveSelection ? normalize(stateSelect.value || initialStateValue) : '';

    stateSelect.innerHTML = '';
    const placeholderOption = document.createElement('option');
    placeholderOption.value = '';
    placeholderOption.textContent = options.length ? statePlaceholderText : stateFallbackText;
    stateSelect.appendChild(placeholderOption);

    if (!options.length) {
        stateSelect.disabled = true;
        stateSelect.value = '';
        return;
    }

    stateSelect.disabled = false;
    options.forEach((item) => {
        const option = document.createElement('option');
        option.value = item.code;
        option.textContent = item.name;
        stateSelect.appendChild(option);
    });

    stateSelect.value = '';
    if (previousValue) {
        const match = options.find((item) => normalize(item.code) === previousValue || normalize(item.name) === previousValue);
        if (match) {
            stateSelect.value = match.code;
        }
    }
}

if (countrySelect && stateSelect) {
    hydrateStateOptions(countrySelect.value || '', true);
    countrySelect.addEventListener('change', () => {
        hydrateStateOptions(countrySelect.value || '', false);
    });
}

const form = document.getElementById('intentForm');
form.addEventListener('submit', async (event) => {
    event.preventDefault();
    const fd = new FormData(form);
    const payload = { name: fd.get('name'), email: fd.get('email'), address: {} };
    for (const [key, value] of fd.entries()) {
        if (key.startsWith('address[')) {
            payload.address[key.slice(8, -1)] = value;
        }
    }
    const res = await fetch('<?php echo e(route('checkout.intent')); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(payload)
    });
    const data = await res.json();
    if (res.ok) {
        window.intent = data;
        document.getElementById('payActions').style.display = 'block';
        form.querySelector('button[type="submit"]').disabled = true;
    } else {
        alert(data.message || 'Failed to create order');
    }
});

document.getElementById('payStripe').addEventListener('click', async () => {
    if (!window.intent) return;
    const res = await fetch('<?php echo e(route('checkout.stripe')); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ order_id: window.intent.order_id })
    });
    const data = await res.json();
    if (data.checkout_url) {
        window.location = data.checkout_url;
    } else {
        alert('Unable to start Stripe checkout');
    }
});

document.getElementById('payPaypal').addEventListener('click', async () => {
    if (!window.intent) return;
    const res = await fetch('<?php echo e(route('checkout.paypal')); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ order_id: window.intent.order_id })
    });
    const data = await res.json();
    if (data.approve_url) {
        window.location = data.approve_url;
    } else {
        alert('Unable to start PayPal checkout');
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.site', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\book_store\resources\views/checkout.blade.php ENDPATH**/ ?>