<?php
    use Illuminate\Support\Collection;

    $fieldId = $id ?? (is_string($name ?? null) ? trim(str_replace(['[',']'], ['_',''], $name), '_') : 'state');
    $selectedValue = is_string($value ?? null) ? strtolower(trim($value)) : null;
    $collection = $states instanceof Collection ? $states : collect($states);
    $hasOptions = $collection->isNotEmpty();
?>

<select
    id="<?php echo e($fieldId); ?>"
    name="<?php echo e($name); ?>"
    <?php echo e($required ? 'required' : ''); ?>

    <?php echo e($hasOptions ? '' : 'disabled'); ?>

    data-placeholder="<?php echo e($placeholder); ?>"
    data-fallback="<?php echo e($fallback); ?>"
    <?php echo e($attributes->class(['input'])); ?>

>
    <option value=""><?php echo e($hasOptions ? $placeholder : $fallback); ?></option>
    <?php $__currentLoopData = $collection; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $code = strtolower((string) ($state['code'] ?? $state));
            $label = (string) ($state['name'] ?? $state);
        ?>
        <option value="<?php echo e(strtoupper($state['code'] ?? $label)); ?>" <?php if($selectedValue === $code): echo 'selected'; endif; ?>>
            <?php echo e($label); ?>

        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>
<?php /**PATH C:\xampp\htdocs\book_store\resources\views/components/select-state.blade.php ENDPATH**/ ?>