<!DOCTYPE html>
<html lang="en" x-data="{ sidebarOpen: false }">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin - <?php echo e(config('app.name', 'Author Bookstore')); ?></title>
    <?php
        $adminAppearance = $siteSettings->appearance();
        $logoPath = $siteSettings->get('brand.logo_path');
        $faviconPath = $siteSettings->get('brand.favicon_path');
        $adminLogo = $logoPath ? \Illuminate\Support\Facades\Storage::disk('public')->url($logoPath) : null;
        $adminFavicon = $faviconPath ? \Illuminate\Support\Facades\Storage::disk('public')->url($faviconPath) : asset('favicon.ico');
        $faviconType = $faviconPath && str_ends_with(strtolower($faviconPath), '.ico') ? 'image/x-icon' : 'image/png';
    ?>
    <link rel="icon" type="<?php echo e($faviconType); ?>" href="<?php echo e($adminFavicon); ?>">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <link rel="stylesheet" href="https://unpkg.com/aos@2.3.4/dist/aos.css">
    <script defer src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script>document.addEventListener('DOMContentLoaded',()=>{ if(window.AOS) AOS.init({ once:true, duration:600 }); });</script>
    <style>
        :root{ --primary:<?php echo e($adminAppearance['primary_color'] ?? '#01637A'); ?>; }
        .btn{ background:var(--primary); color:#fff; padding:.5rem 1rem; border-radius:.375rem }
        .btn-secondary{ border:1px solid #cbd5e1; padding:.5rem 1rem; border-radius:.375rem }
        .nav-link{ display:block; padding:.5rem .75rem; border-radius:.375rem; color:#334155 }
        .nav-link:hover{ color:var(--primary); background:#f8fafc }
        .nav-active{ background:#e6f6f9; color:var(--primary); font-weight:600; }
        .badge{ display:inline-block; font-size:.75rem; line-height:1; padding:.25rem .5rem; border-radius:.375rem }
        .badge-yellow{ background:#fef9c3; color:#854d0e }
        .badge-blue{ background:#e0f2fe; color:#075985 }
        .badge-red{ background:#fee2e2; color:#991b1b }
        .table-sticky thead th{ position: sticky; top: 0; background:#f8fafc; z-index: 10; }
        .table-hover tbody tr:hover{ background:#f9fafb; }
        .brand-mini-logo{height:32px;width:auto;border-radius:8px;object-fit:contain;background:#fff;padding:2px;box-shadow:0 2px 6px rgba(15,23,42,0.12)}
    </style>
</head>
<body class="min-h-screen bg-slate-50 text-slate-800">
    <!-- Header -->
    <header class="bg-white border-b border-slate-200">
        <div class="max-w-7xl mx-auto px-4 h-14 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <button class="md:hidden btn-secondary" @click="sidebarOpen = !sidebarOpen">Menu</button>
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="flex items-center gap-2">
                    <?php if($adminLogo): ?>
                        <img src="<?php echo e($adminLogo); ?>" alt="Admin logo" class="brand-mini-logo">
                    <?php else: ?>
                        <img src="<?php echo e($adminFavicon); ?>" alt="Admin" class="w-6 h-6 rounded">
                    <?php endif; ?>
                    <span class="font-semibold">Admin</span>
                </a>
            </div>
            <div class="flex items-center gap-3 text-sm">
                <span class="text-slate-600 hidden sm:block"><?php echo e(auth()->user()->name); ?></span>
                <form action="<?php echo e(route('logout')); ?>" method="post"><?php echo csrf_field(); ?> <button class="btn">Logout</button></form>
            </div>
        </div>
    </header>

    <!-- Shell: sidebar + content -->
    <div class="max-w-7xl mx-auto px-4 py-6 grid grid-cols-12 gap-6">
        <?php ($__admin_counts = [
            'pendingOrders' => \App\Models\Order::where('status','pending')->count(),
            'pendingComments' => \App\Models\Comment::where('status','pending')->count(),
            'lowStock' => \App\Models\Product::where('stock','<=',5)->count(),
        ]); ?>
        <aside class="col-span-12 md:col-span-3 lg:col-span-2" :class="sidebarOpen ? 'block' : 'hidden md:block'">
            <nav class="bg-white border border-slate-200 rounded p-3 text-sm md:sticky md:top-4" x-data="{q:''}">
                <div class="mb-2">
                    <input x-model="q" placeholder="Search menu..." class="w-full border border-slate-300 rounded px-2 py-1 text-sm" />
                </div>
                <div class="text-[0.7rem] uppercase tracking-widest text-slate-500 px-2">Overview</div>
                <ul class="space-y-1 mb-2">
                    <li x-show="!q || 'dashboard'.includes(q.toLowerCase())"><a href="<?php echo e(route('admin.dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'nav-active' : ''); ?>">Dashboard</a></li>
                </ul>
                <div class="h-px bg-slate-200 my-2"></div>
                <div class="text-[0.7rem] uppercase tracking-widest text-slate-500 px-2">Management</div>
                <ul class="space-y-1 mb-2">
                    <li x-show="!q || 'products'.includes(q.toLowerCase())"><a href="<?php echo e(route('admin.products.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.products.*') ? 'nav-active' : ''); ?>">Products <?php if($__admin_counts['lowStock']>0): ?><span class="badge badge-red ml-1"><?php echo e($__admin_counts['lowStock']); ?></span><?php endif; ?></a></li>
                    <li x-show="!q || 'low stock'.includes(q.toLowerCase())"><a href="<?php echo e(route('admin.products.index', ['low'=>1])); ?>" class="nav-link">Low stock</a></li>
                    <li x-show="!q || 'categories'.includes(q.toLowerCase())"><a href="<?php echo e(route('admin.categories.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.categories.*') ? 'nav-active' : ''); ?>">Categories</a></li>
                    <li x-show="!q || 'orders'.includes(q.toLowerCase())"><a href="<?php echo e(route('admin.orders.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.orders.*') ? 'nav-active' : ''); ?>">Orders <?php if($__admin_counts['pendingOrders']>0): ?><span class="badge badge-yellow ml-1"><?php echo e($__admin_counts['pendingOrders']); ?></span><?php endif; ?></a></li>
                </ul>
                <div class="h-px bg-slate-200 my-2"></div>
                <div class="text-[0.7rem] uppercase tracking-widest text-slate-500 px-2">Content</div>
                <ul class="space-y-1 mb-2">
                    <li x-show="!q || 'posts'.includes(q.toLowerCase())"><a href="<?php echo e(route('admin.posts.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.posts.*') ? 'nav-active' : ''); ?>">Posts</a></li>
                    <li x-show="!q || 'newsletters'.includes(q.toLowerCase())"><a href="<?php echo e(route('admin.newsletters.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.newsletters.*') ? 'nav-active' : ''); ?>">Newsletters</a></li>
                    <li x-show="!q || 'comments'.includes(q.toLowerCase())"><a href="<?php echo e(route('admin.comments.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.comments.*') ? 'nav-active' : ''); ?>">Comments <?php if($__admin_counts['pendingComments']>0): ?><span class="badge badge-blue ml-1"><?php echo e($__admin_counts['pendingComments']); ?></span><?php endif; ?></a></li>
                </ul>
                <?php if(auth()->user()->role === 'admin'): ?>
                <div class="h-px bg-slate-200 my-2"></div>
                <div class="text-[0.7rem] uppercase tracking-widest text-slate-500 px-2">System</div>
                <ul class="space-y-1">
                    <li x-show="!q || 'settings'.includes(q.toLowerCase())"><a href="<?php echo e(route('admin.settings.edit')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.settings.*') ? 'nav-active' : ''); ?>">Settings</a></li>
                    <li x-show="!q || 'appearance'.includes(q.toLowerCase()) || 'site'.includes(q.toLowerCase())"><a href="<?php echo e(route('admin.site.edit')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.site.*') ? 'nav-active' : ''); ?>">Appearance</a></li>
                </ul>
                <?php endif; ?>
            </nav>
        </aside>
        <main class="col-span-12 md:col-span-9 lg:col-span-10">
            <?php echo $__env->yieldContent('content'); ?>
            <footer class="mt-10 text-xs text-slate-500"> <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>  Admin Panel</footer>
        </main>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\book_store\resources\views/layouts/admin.blade.php ENDPATH**/ ?>