<?php $__env->startSection('title', 'Books'); ?>
<?php $booksContent = $siteSettings->content('books'); ?>
<?php $__env->startSection('meta_description', $booksContent['index_intro'] ?? 'Browse the full catalog of books and merchandise available from BrightQuill.'); ?>

<?php
    $currency = config('payment.currency_symbol', '$');
    $filtersActive = $isFiltered ?? false;
    $currentFilter = $filter ?? 'latest';
    $currentCategory = isset($categoryId) && $categoryId !== null ? (string) $categoryId : '';
    $currentType = $type ?? '';
    $currentSort = $sort ?? '';
    $currentMin = isset($min) && $min !== null ? (string) $min : '';
    $currentMax = isset($max) && $max !== null ? (string) $max : '';
    $currentSearch = $q ?? '';
?>

<?php $__env->startSection('content'); ?>
<section class="section reveal">
    <div class="container">
        <h1 class="mt-0"><?php echo e($booksContent['index_title'] ?? 'Browse the shelves'); ?></h1>
        <p><?php echo e($booksContent['index_intro'] ?? 'Use the filters to find the perfect read, from cozy essays to high-stakes fiction and limited-edition merch.'); ?></p>
        <form class="grid grid-3 mt-2" method="get" style="gap:1rem;">
            <input class="input" type="text" name="q" value="<?php echo e($currentSearch); ?>" placeholder="Search by title or keyword">
            <select class="select" name="category_id">
                <option value="">All categories</option>
                <?php $__currentLoopData = ($categories ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($cat->id); ?>" <?php if($currentCategory !== '' && $currentCategory == $cat->id): echo 'selected'; endif; ?>><?php echo e($cat->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <select class="select" name="type">
                <option value="">Format</option>
                <?php $__currentLoopData = ['paperback','hardcover','ebook','merch']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $typeOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($typeOption); ?>" <?php if($currentType === $typeOption): echo 'selected'; endif; ?>><?php echo e(ucfirst($typeOption)); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <input class="input" type="number" min="0" name="min" value="<?php echo e($currentMin); ?>" placeholder="Min price (kobo)">
            <input class="input" type="number" min="0" name="max" value="<?php echo e($currentMax); ?>" placeholder="Max price (kobo)">
            <select class="select" name="sort">
                <option value="">Newest</option>
                <option value="price_asc" <?php if($currentSort === 'price_asc'): echo 'selected'; endif; ?>>Price: Low to High</option>
                <option value="price_desc" <?php if($currentSort === 'price_desc'): echo 'selected'; endif; ?>>Price: High to Low</option>
            </select>
            <select class="select" name="filter">
                <option value="latest" <?php if($currentFilter === 'latest'): echo 'selected'; endif; ?>>Latest</option>
                <option value="discounted" <?php if($currentFilter === 'discounted'): echo 'selected'; endif; ?>>Discounted</option>
                <option value="featured" <?php if($currentFilter === 'featured'): echo 'selected'; endif; ?>>Featured</option>
            </select>
            <button class="btn btn-primary" type="submit">Apply filters</button>
        </form>
        <div class="grid grid-3 mt-2">
            <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <article class="card reveal">
                    <img src="<?php echo e($book->cover_path ? asset($book->cover_path) : asset('brightquill/assets/placeholder-cover.svg')); ?>" alt="<?php echo e($book->title); ?>">
                    <div class="card-body">
                        <h3 class="card-title"><?php echo e($book->title); ?></h3>
                        <p class="card-sub"><?php echo e($book->excerpt ?: \Illuminate\Support\Str::limit($book->description ?? '', 100, '...')); ?></p>
                        <div class="row" style="justify-content:space-between;align-items:center;">
                            <span class="price"><?php echo e($currency); ?><?php echo e(number_format($book->price / 100, 2)); ?></span>
                            <?php if($book->category): ?>
                                <span class="small"><?php echo e($book->category->name); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="row mt-2" style="gap:.5rem;flex-wrap:wrap;">
                            <a class="btn btn-outline" href="<?php echo e(route('books.show', $book->slug)); ?>"><?php echo e($siteSettings->get('content.books.view_button_label', 'View')); ?></a>
                            <form action="<?php echo e(route('cart.add', $book->slug)); ?>" method="post" style="margin:0;">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="qty" value="1">
                                <button class="btn btn-primary" type="submit"><?php echo e($booksContent['add_button_label'] ?? 'Add'); ?></button>
                            </form>
                        </div>
                    </div>
                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php if($filtersActive): ?>
                    <p class="small">No products matched your filters. Try adjusting your search.</p>
                <?php else: ?>
                    <p class="small">No books are available yet. Please check back soon.</p>
                <?php endif; ?>
            <?php endif; ?>
        </div>
        <div class="mt-3"><?php echo e($products->links()); ?></div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\book_store\resources\views/books/index.blade.php ENDPATH**/ ?>