<?php $cartContent = $siteSettings->content('cart'); ?>
<?php $__env->startSection('title', $cartContent['title'] ?? 'Your cart'); ?>
<?php $__env->startSection('meta_description', $cartContent['empty_message'] ?? 'Review the books and merchandise currently saved in your cart.'); ?>

<?php
    $currency = config('payment.currency_symbol', '$');
?>

<?php $__env->startSection('content'); ?>
<section class="section reveal">
    <div class="container">
        <h1 class="mt-0"><?php echo e($cartContent['title'] ?? 'Your cart'); ?></h1>
        <?php if(empty($items)): ?>
            <p class="small"><?php echo e($cartContent['empty_message'] ?? 'Your cart is empty.'); ?> <a href="<?php echo e(route('books.index')); ?>"><?php echo e($siteSettings->get('content.cart.empty_cta', 'Explore the catalog')); ?></a></p>
        <?php else: ?>
            <div class="grid" style="gap:1rem;">
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article class="card reveal" style="display:flex;gap:1rem;align-items:flex-start;">
                        <img src="<?php echo e($item['cover_path'] ?: asset('brightquill/assets/placeholder-cover.svg')); ?>" alt="<?php echo e($item['title']); ?>" style="width:96px;height:128px;object-fit:cover;border-radius:12px;">
                        <div class="card-body" style="padding:0;flex:1;">
                            <h3 class="card-title" style="margin-bottom:.35rem;"><?php echo e($item['title']); ?></h3>
                            <p class="text-xs uppercase tracking-wide text-slate-500" style="margin:0 0 .5rem 0;"><?php echo e($item['variant_label'] ?? (($item['is_digital'] ?? false) ? 'DIGITAL' : 'HARDCOPY')); ?></p>
                            <p class="card-sub">
                                <?php echo e($currency); ?><?php echo e(number_format(($item['price_kobo'] ?? 0)/100, 2)); ?>

                                <?php if(($item['shipping_fee_kobo'] ?? 0) > 0): ?>
                                    <span class="text-xs text-slate-500">+ <?php echo e($currency); ?><?php echo e(number_format(($item['shipping_fee_kobo'] ?? 0)/100, 2)); ?> shipping</span>
                                <?php endif; ?>
                            </p>
                            <?php if(!($item['is_digital'] ?? false)): ?>
                                <form class="row" action="<?php echo e(route('cart.update')); ?>" method="post" style="gap:.75rem;align-items:center;margin-top:0.5rem;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>
                                    <input type="hidden" name="product_id" value="<?php echo e($item['product_id']); ?>">
                                    <input type="hidden" name="variant" value="<?php echo e($item['variant'] ?? 'digital'); ?>">
                                    <label class="small" for="qty-<?php echo e($loop->index); ?>">Qty</label>
                                    <input class="input" id="qty-<?php echo e($loop->index); ?>" style="max-width:110px;" type="number" min="0" name="qty" value="<?php echo e($item['qty']); ?>">
                                    <button class="btn btn-outline" type="submit"><?php echo e($siteSettings->get('content.cart.update_label', 'Update')); ?></button>
                                </form>
                            <?php else: ?>
                                <p class="small text-slate-500" style="margin-top:0.5rem;">Digital items are limited to a single copy per order.</p>
                            <?php endif; ?>
                        </div>
                        <form action="<?php echo e(route('cart.remove')); ?>" method="post" style="margin-left:auto;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="hidden" name="product_id" value="<?php echo e($item['product_id']); ?>">
                            <input type="hidden" name="variant" value="<?php echo e($item['variant'] ?? 'digital'); ?>">
                            <button class="btn btn-outline" type="submit"><?php echo e($siteSettings->get('content.cart.remove_label', 'Remove')); ?></button>
                        </form>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="card mt-3 reveal">
                <div class="card-body" style="display:flex;flex-wrap:wrap;gap:1rem;justify-content:space-between;align-items:center;">
                    <div>
                        <div class="text-sm text-slate-500"><?php echo e($cartContent['subtotal_label'] ?? 'Subtotal'); ?>: <?php echo e($currency); ?><?php echo e(number_format(($subtotalKobo ?? 0)/100, 2)); ?></div>
                        <?php if(($shippingKobo ?? 0) > 0): ?>
                            <div class="text-sm text-slate-500"><?php echo e($cartContent['shipping_label'] ?? 'Shipping'); ?>: <?php echo e($currency); ?><?php echo e(number_format(($shippingKobo ?? 0)/100, 2)); ?></div>
                        <?php endif; ?>
                        <div class="h1" style="font-size:1.4rem;margin:0;"><?php echo e($cartContent['total_label'] ?? 'Total'); ?>: <?php echo e($currency); ?><?php echo e(number_format(($totalKobo ?? 0)/100, 2)); ?></div>
                    </div>
                    <div style="display:flex;flex-direction:column;gap:.5rem;align-items:flex-end;min-width:220px;">
                        <a class="btn btn-primary" href="<?php echo e(route('checkout.show')); ?>"><?php echo e($cartContent['checkout_label'] ?? 'Proceed to checkout'); ?></a>
                        <?php if(auth()->guard()->guest()): ?>
                            <p class="small" style="text-align:right;"><?php echo e($cartContent['guest_prompt'] ?? 'Have an account? Log in to save your order history.'); ?> <a href="<?php echo e(route('login')); ?>"><?php echo e($cartContent['login_label'] ?? 'Login'); ?></a><?php if(Route::has('register')): ?> or <a href="<?php echo e(route('register')); ?>"><?php echo e($cartContent['register_label'] ?? 'Create an account'); ?></a><?php endif; ?>.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\book_store\resources\views/cart.blade.php ENDPATH**/ ?>