<?php $__env->startSection('title', 'Promotions'); ?>
<?php $promotionsContent = $siteSettings->content('promotions'); ?>
<?php $__env->startSection('meta_description', $promotionsContent['index_intro'] ?? 'Special giveaways, launch bonuses, and community events hosted by BrightQuill.'); ?>

<?php $__env->startSection('content'); ?>
<section class="section reveal">
    <div class="container">
        <h1 class="mt-0"><?php echo e($promotionsContent['index_title'] ?? 'Current promotions'); ?></h1>
        <p><?php echo e($promotionsContent['index_intro'] ?? 'Limited-time treats for readers and creative partners. Enter below and share with your book club.'); ?></p>
        <div class="grid grid-3 mt-2">
            <?php $__currentLoopData = $promotions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $promotion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <article class="card reveal">
                    <div class="card-body">
                        <div class="badge-pill">Code: <?php echo e($promotion->code); ?></div>
                        <h3 class="card-title"><?php echo e($promotion->title); ?></h3>
                        <p class="card-sub"><?php echo e(\Illuminate\Support\Str::limit($promotion->description, 120, '...')); ?></p>
                        <a class="btn btn-primary mt-2" href="<?php echo e(route('promotions.show', $promotion->code)); ?>"><?php echo e($promotionsContent['view_details_label'] ?? 'View details'); ?></a>
                    </div>
                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="mt-3"><?php echo e($promotions->links()); ?></div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\book_store\resources\views/promotions/index.blade.php ENDPATH**/ ?>