﻿

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 py-8" data-aos="fade-up">
    <div class="flex items-center justify-between mb-4">
        <div>
            <h1 class="heading text-3xl">Dashboard</h1>
            <div class="text-sm text-slate-600">Welcome, <?php echo e(auth()->user()->name); ?></div>
        </div>
        <div class="flex flex-wrap gap-2">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', \App\Models\Product::class)): ?>
            <a href="<?php echo e(route('admin.products.create')); ?>" class="btn">+ New Product</a>
            <?php endif; ?>
            <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn-secondary">View Orders</a>
            <a href="<?php echo e(route('admin.comments.index')); ?>" class="btn-secondary">Moderate Comments</a>
            <?php if(auth()->user()->role === 'admin'): ?>
            <a href="<?php echo e(route('admin.settings.edit')); ?>" class="btn-secondary">Settings</a>
            <?php endif; ?>
        </div>
    </div>

    <div class="grid md:grid-cols-6 gap-4 mb-6">
        <a href="<?php echo e(route('admin.products.index')); ?>" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in">
            <div class="text-slate-500 text-sm">Products</div>
            <div class="text-3xl font-bold text-primary"><?php echo e($stats['products']); ?></div>
            <div class="mt-1 text-xs text-slate-500">Low stock: <?php echo e($stats['low_stock']); ?></div>
        </a>
        <a href="<?php echo e(route('admin.products.index', ['low'=>1])); ?>" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in" data-aos-delay="25">
            <div class="text-slate-500 text-sm">Low Stock</div>
            <div class="text-3xl font-bold text-primary"><?php echo e($stats['low_stock']); ?></div>
            <div class="mt-1 text-xs text-slate-500">Stock &le; 5</div>
        </a>
        <a href="<?php echo e(route('admin.orders.index')); ?>" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in" data-aos-delay="50">
            <div class="text-slate-500 text-sm">Orders</div>
            <div class="text-3xl font-bold text-primary"><?php echo e($stats['orders']); ?></div>
            <div class="mt-1 text-xs text-slate-500">Pending: <?php echo e($stats['pending_orders']); ?></div>
        </a>
        <a href="<?php echo e(route('admin.posts.index')); ?>" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in" data-aos-delay="100">
            <div class="text-slate-500 text-sm">Posts</div>
            <div class="text-3xl font-bold text-primary"><?php echo e($stats['posts']); ?></div>
        </a>
        <a href="<?php echo e(route('admin.comments.index')); ?>" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in" data-aos-delay="150">
            <div class="text-slate-500 text-sm">Comments</div>
            <div class="text-3xl font-bold text-primary"><?php echo e($stats['pending_comments']); ?></div>
            <div class="mt-1 text-xs text-slate-500">Pending</div>
        </a>
        <?php if(auth()->user()->role === 'admin'): ?>
        <a href="<?php echo e(route('admin.settings.edit')); ?>" class="bg-white border border-slate-200 rounded p-4 shadow-sm block" data-aos="zoom-in" data-aos-delay="200">
            <div class="text-slate-500 text-sm">Settings</div>
            <div class="text-3xl font-bold text-primary">&#9881;</div>
            <div class="mt-1 text-xs text-slate-500">Payments &amp; more</div>
        </a>
        <?php endif; ?>
    </div>

    <div class="grid lg:grid-cols-2 gap-6">
        <div class="bg-white border border-slate-200 rounded p-4 shadow-sm">
            <div class="flex items-center justify-between mb-3">
                <div class="font-semibold">Latest Orders</div>
                <a href="<?php echo e(route('admin.orders.index')); ?>" class="text-primary text-sm">View all</a>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm table-sticky table-hover">
                    <thead class="bg-slate-50 border-b border-slate-200">
                        <tr><th class="p-2 text-left">Ref</th><th class="p-2">Email</th><th class="p-2">Amount</th><th class="p-2">Status</th><th class="p-2">Type</th></tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $latestOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-b border-slate-100">
                            <td class="p-2"><a class="text-primary" href="<?php echo e(route('admin.orders.show', $order)); ?>"><?php echo e($order->reference); ?></a></td>
                            <td class="p-2 text-center"><?php echo e($order->email); ?></td>
                            <td class="p-2 text-center"><?php echo e(config('payment.currency_symbol', '$')); ?><?php echo e(number_format($order->amount_kobo/100,2)); ?></td>
                            <td class="p-2 text-center"><?php echo e(ucfirst($order->status)); ?></td>
                            <td class="p-2 text-center"><?php if(data_get($order->metadata,'is_test')): ?><span class="inline-block text-xs bg-yellow-100 text-yellow-800 px-2 py-0.5 rounded">Test</span><?php else: ?> Real <?php endif; ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td class="p-3 text-slate-500" colspan="5">No orders yet.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="bg-white border border-slate-200 rounded p-4 shadow-sm">
            <div class="flex items-center justify-between mb-3">
                <div class="font-semibold">Recent Posts</div>
                <div class="flex gap-2">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', \App\Models\Product::class)): ?>
                    <a href="<?php echo e(route('admin.products.create')); ?>" class="btn px-3 py-1">New Product</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', \App\Models\Post::class)): ?>
                    <a href="<?php echo e(route('admin.posts.create')); ?>" class="btn px-3 py-1">New Post</a>
                    <?php endif; ?>
                </div>
            </div>
            <ul class="text-sm space-y-2">
                <?php $__empty_1 = true; $__currentLoopData = $recentPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <li class="flex justify-between">
                    <a class="text-primary" href="<?php echo e(route('admin.posts.edit', $post)); ?>"><?php echo e($post->title); ?></a>
                    <span class="text-slate-500"><?php echo e(optional($post->published_at)->format('Y-m-d') ?: 'Draft'); ?></span>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <li class="text-slate-500">No posts yet.</li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\book_store\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>