<?php $__env->startSection('title', 'Home'); ?>
<?php $homeContent = $siteSettings->content('home'); ?>
<?php $__env->startSection('meta_description', $homeContent['hero_lead'] ?? 'Discover uplifting fiction, thoughtful essays, and reader-first promotions.'); ?>

<?php
    $currency = config('payment.currency_symbol', '$');
?>

<?php $__env->startSection('content'); ?>
<section class="container hero reveal">
    <div>
        <div class="kicker"><?php echo e($homeContent['hero_kicker'] ?? 'Playful & Original'); ?></div>
        <h1 class="h1"><?php echo e($homeContent['hero_title'] ?? 'Stories that spark calm courage.'); ?></h1>
        <p class="lead"><?php echo e($homeContent['hero_lead'] ?? 'Discover uplifting fiction and practical guides crafted for readers who want clarity without losing wonder.'); ?></p>
        <div class="cta-row">
            <a class="btn btn-primary" href="<?php echo e(route('books.index')); ?>"><?php echo e($homeContent['hero_primary_label'] ?? 'Browse Books'); ?></a>
            <a class="btn btn-outline" href="<?php echo e(route('blog.index')); ?>"><?php echo e($homeContent['hero_secondary_label'] ?? 'Read the Blog'); ?></a>
        </div>
    </div>
    <div class="card center reveal">
        <img src="<?php echo e(asset('brightquill/assets/placeholder-cover.svg')); ?>" alt="Illustrative book stack" style="width:min(420px,100%);">
    </div>
</section>

<section class="section stripe reveal">
    <div class="container">
        <h2 class="mt-0"><?php echo e($homeContent['featured_heading'] ?? 'Featured Books'); ?></h2>
        <p class="small mt-1"><?php echo e($homeContent['featured_subheading'] ?? 'Handpicked titles that readers keep recommending.'); ?></p>
        <div class="grid grid-3 mt-2">
            <?php $__empty_1 = true; $__currentLoopData = $featured->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <article class="card reveal">
                    <img src="<?php echo e($book->cover_path ? asset($book->cover_path) : asset('brightquill/assets/placeholder-cover.svg')); ?>" alt="Cover for <?php echo e($book->title); ?>" style="height:220px;object-fit:cover;width:100%;">
                    <div class="card-body">
                        <h3 class="card-title"><?php echo e($book->title); ?></h3>
                        <p class="card-sub"><?php echo e($book->excerpt ?: \Illuminate\Support\Str::limit($book->description ?? '', 110, '...')); ?></p>
                        <div class="row" style="align-items:center;justify-content:space-between;">
                            <span class="price"><?php echo e($currency); ?><?php echo e(number_format($book->price/100, 2)); ?></span>
                            <?php if($book->type): ?>
                                <span class="small" style="color:var(--muted);"><?php echo e(ucfirst($book->type)); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="row mt-2" style="gap:.5rem;flex-wrap:wrap;">
                            <a class="btn btn-outline" href="<?php echo e(route('books.show', $book->slug)); ?>"><?php echo e($siteSettings->get('content.books.view_button_label', 'View')); ?></a>
                            <form action="<?php echo e(route('cart.add', $book->slug)); ?>" method="post" style="margin:0;">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="qty" value="1">
                                <button class="btn btn-primary" type="submit"><?php echo e($siteSettings->get('content.books.add_button_label', 'Add')); ?></button>
                            </form>
                        </div>
                    </div>
                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="small">New releases are brewing behind the scenes. Check back soon.</p>
            <?php endif; ?>
        </div>
        <div class="mt-3">
            <a class="btn btn-primary" href="<?php echo e(route('books.index')); ?>"><?php echo e($siteSettings->get('content.home.view_all_label', 'Explore the full shelf')); ?></a>
        </div>
    </div>
</section>

<section class="section reveal">
    <div class="container grid grid-2">
        <div>
            <h2 class="mt-0"><?php echo e($homeContent['about_title'] ?? 'About the author'); ?></h2>
            <p><?php echo e($homeContent['about_body'] ?? 'We champion stories and resources that make readers feel braver, calmer, and more connected.'); ?></p>
            <a class="btn btn-primary mt-2" href="<?php echo e(route('about')); ?>"><?php echo e($homeContent['about_cta_label'] ?? 'Learn more'); ?></a>
        </div>
        <div class="card center promo-swing reveal">
            <div class="card-body">
                <div class="badge-pill"><?php echo e($homeContent['promo_badge'] ?? 'Upcoming'); ?></div>
                <h3 class="mt-2"><?php echo e($homeContent['promo_title'] ?? 'Sky Lantern Notes'); ?></h3>
                <p><?php echo e($homeContent['promo_body'] ?? 'Short reflections for calm, focus, and courage. Join the launch list to enjoy first-look chapters and preorder bonuses.'); ?></p>
                <a class="btn btn-outline" href="<?php echo e(route('promotions.index')); ?>"><?php echo e($siteSettings->get('content.home.promo_cta_label', 'Get updates')); ?></a>
            </div>
        </div>
    </div>
</section>

<section class="section stripe reveal">
    <div class="container">
        <h2 class="mt-0"><?php echo e($homeContent['testimonials_title'] ?? 'What readers say'); ?></h2>
        <div class="grid grid-3 mt-2">
            <?php $__currentLoopData = [1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $quote = $homeContent['testimonial_' . $index . '_quote'] ?? null;
                    $name = $homeContent['testimonial_' . $index . '_name'] ?? null;
                ?>
                <?php if($quote && $name): ?>
                    <div class="card reveal"><div class="card-body"><p><?php echo e($quote); ?></p><p class="small">� <?php echo e($name); ?></p></div></div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<?php if($posts->isNotEmpty()): ?>
<section class="section reveal">
    <div class="container">
        <div class="row" style="justify-content:space-between;align-items:flex-end;gap:1rem;flex-wrap:wrap;">
            <div>
                <h2 class="mt-0"><?php echo e($homeContent['blog_title'] ?? 'Fresh from the blog'); ?></h2>
                <p class="small"><?php echo e($homeContent['blog_subheading'] ?? 'Practical tips and behind-the-pages reflections.'); ?></p>
            </div>
            <a class="btn btn-outline" href="<?php echo e(route('blog.index')); ?>"><?php echo e($siteSettings->get('content.home.blog_cta_label', 'View all posts')); ?></a>
        </div>
        <div class="grid grid-3 mt-2">
            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <article class="card reveal">
                    <div class="card-body">
                        <h3 class="card-title"><?php echo e($post->title); ?></h3>
                        <p class="card-sub"><?php echo e($post->excerpt); ?></p>
                        <a class="btn btn-primary mt-2" href="<?php echo e(route('blog.show', $post->slug)); ?>"><?php echo e($siteSettings->get('content.blog.read_story_label', 'Read story')); ?></a>
                    </div>
                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>

<section class="section stripe reveal">
    <div class="container grid grid-2">
        <div>
            <h2 class="mt-0"><?php echo e($homeContent['newsletter_title'] ?? "Let's stay in touch"); ?></h2>
            <p><?php echo e($homeContent['newsletter_body'] ?? 'Get launch invites, giveaways, and reading prompts straight to your inbox.'); ?></p>
            <form class="mt-3" action="<?php echo e(route('newsletter.subscribe')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="form-row">
                    <input class="input" type="email" name="email" placeholder="you@example.com" required aria-label="Email">
                    <button class="btn btn-primary" type="submit"><?php echo e($siteSettings->get('content.home.newsletter_cta_label', 'Subscribe')); ?></button>
                </div>
                <p class="small mt-1"><?php echo e($siteSettings->get('content.footer_newsletter_hint', 'No spam. Unsubscribe anytime.')); ?></p>
            </form>
        </div>
        <div>
            <h2 class="mt-0"><?php echo e($homeContent['contact_title'] ?? 'Share a quick note'); ?></h2>
            <p><?php echo e($homeContent['contact_body'] ?? "Have an event idea or want to collaborate? Leave a message and we'll get back to you."); ?></p>
            <form class="mt-3" action="<?php echo e(route('contact.send')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input class="input" type="text" name="name" placeholder="Your name" required>
                <div class="form-row mt-2">
                    <input class="input" type="email" name="email" placeholder="Your email" required>
                </div>
                <textarea class="textarea mt-2" name="message" rows="4" placeholder="How can we help?" required></textarea>
                <button class="btn btn-outline mt-2" type="submit"><?php echo e($siteSettings->get('content.contact.form_submit_label', 'Send message')); ?></button>
            </form>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\book_store\resources\views/home.blade.php ENDPATH**/ ?>