<?php
    $fieldId = $id ?? (is_string($name ?? null) ? trim(str_replace(['[',']'], ['_',''], $name), '_') : 'country');
    $selectedValue = is_string($value ?? null) ? strtolower(trim($value)) : null;
?>

<select
    id="<?php echo e($fieldId); ?>"
    name="<?php echo e($name); ?>"
    <?php echo e($required ? 'required' : ''); ?>

    <?php echo e($attributes->class(['input'])); ?>

>
    <option value=""><?php echo e($placeholder); ?></option>
    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $code = strtolower((string) ($country['code'] ?? $country));
            $label = (string) ($country['name'] ?? $country);
        ?>
        <option value="<?php echo e(strtoupper($country['code'] ?? $label)); ?>" <?php if($selectedValue === $code): echo 'selected'; endif; ?>>
            <?php echo e($label); ?>

        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>
<?php /**PATH C:\xampp\htdocs\book_store\resources\views/components/select-country.blade.php ENDPATH**/ ?>