<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'Book Store')); ?>  Auth</title>

        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="min-h-screen bg-gradient-to-br from-teal-100 via-cyan-100 to-emerald-100">
        <div class="relative">
            <div aria-hidden="true" class="pointer-events-none absolute -top-24 -left-24 h-96 w-96 rounded-full bg-teal-300/40 blur-3xl"></div>
            <div aria-hidden="true" class="pointer-events-none absolute -bottom-24 -right-24 h-96 w-96 rounded-full bg-cyan-300/40 blur-3xl"></div>
        </div>

        <div class="relative mx-auto flex min-h-screen max-w-6xl items-center justify-center px-4 py-8 sm:px-6 lg:px-8">
            <div class="grid w-full grid-cols-1 overflow-hidden rounded-3xl bg-white shadow-2xl md:grid-cols-2">
                <div class="hidden md:block bg-white p-8">
                    <div class="flex h-full items-center justify-center">
                        <img src="<?php echo e(asset('img/glasses-1052023_1280.jpg')); ?>" alt="Welcome" class="h-80 w-full rounded-2xl object-cover object-center">
                    </div>
                </div>
                <div class="p-6 sm:p-8 lg:p-10">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </body>
    </html>




<?php /**PATH C:\xampp\htdocs\book_store\resources\views/layouts/auth-card.blade.php ENDPATH**/ ?>