import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Inter', ...defaultTheme.fontFamily.sans],
                display: ['Playfair Display', 'Georgia', ...defaultTheme.fontFamily.serif],
            },
            colors: {
                primary: '#01637A',
                accent: '#fcb900',
                ink: '#1f2937',
                paper: '#ffffff',
            },
        },
    },

    plugins: [forms],
};
